/*-----------------------------------------------------------------------------
   Copyright (c) 1993 Regents of the University of California  
                     All Rights Reserved                          
 -----------------------------------------------------------------------------
  TestFdReady() : Test the file descriptor to see if it is ready
  for read, write, or if and error has accurred.  
  
  fd      : the file descriptor
  request : IO_READ  = test for to see if a read  is possible.
            IO_WRITE = test for to see if a write is possible.
	    IO_ERROR = test to see if there has been an error,
	               for example the pipe or socket has been
		       closed.

 This function is used with async execution of programs, to make
 should the program does not block on IO.

  Developement History:
    Begun: 7/23/93 - Gilbert Hyatt

------------------------------------------------------------------------------*/
#include <stdio.h>      /*  for NULL        */
#include <sys/types.h>  /*  for select      */
#include <sys/time.h>   /*  for select      */
#include "miscc.h"

int 
TestFdReady (int fd, int request)
{
  fd_set *readfds, *writefds, *exceptfds, requestfds;
  struct timeval timeout;
  
  readfds   = NULL;
  writefds  = NULL;
  exceptfds = NULL;

  timeout.tv_sec  =0;
  timeout.tv_usec =0;
  FD_ZERO(&requestfds);
  FD_SET(fd, &requestfds);

  switch(request) {
    case IO_READ:  readfds   = &requestfds; 
                   break;
    case IO_WRITE: writefds  = &requestfds; 
                   break;
    case IO_ERROR: exceptfds = &requestfds; 
                   break;
  }  /* end of switch */
  
  select(FD_SETSIZE, readfds, writefds, exceptfds, &timeout);
  return(FD_ISSET(fd, &requestfds));
}
