/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- FIND_REP ---------------------------------------*/
/* Function to find and replace all occurances       */
/* a given substring with another string in a source */
/* string.                                           */
/* Returns the number of replacements made           */
/*                                                   */
/* On Entry:                                         */
/*  IN: The string to search for the word to replace */
/* FIND: The string to find in IN.                   */
/*  REP: The string to replace FIND with.            */
/*                                                   */
/* NOTE: A buffer area must be declared which will   */
/*       hold all temporary strings. This buffer must*/
/*       be large enough to accomodate               */
/*	 a string as long as the sum of the width and*/
/*       margin. The name of this buffer MUST be:    */
/*                                                   */
/*            Tmpbuffer                              */
/*                                                   */
/* Development History:                              */
/*    Begun: 8/31/85 - Todd King                     */
/*          Under GY49 support.                      */
/*                                                   */
/*  Version:                                         */
/*     %W%      (UCLA/IGPP)     %G%                  */
/*---------------------------------------------------*/

char	Tmpbuffer[2048]; 

int 
findrep (char in[], char find[], char rep[])
{
  int ret,n,m,cnt;
  char *ptr;

  n=0;
  cnt = 0;
  ptr=(&in[n]);
  strcpy(Tmpbuffer,"");

  while((ret=findstr(find,ptr,'"')) != -1)
  {
    ptr[ret]='\0';
    strcat(Tmpbuffer,ptr);
    strcat(Tmpbuffer,rep);
    n=ret+strlen(find);
    ptr=(&ptr[n]);
    cnt++;
  }
  if(cnt > 0)  /* Finish up - replacements made */
  {
    strcat(Tmpbuffer,ptr);
    strcpy(in,Tmpbuffer);
  }
  return(cnt);
}

