/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- FINDSTR ----------------------------*/
/* Searches a string for the occurance   */
/* of another. A single character may be */
/* specified as the search toggle. If    */
/* the character is found without a      */
/* concecutive character following it    */
/* it toggles the search state until     */
/* another of the characters is found.   */
/* A integer zero for the toggle         */
/* character is the best way to search   */
/* for no toggle since this is the       */
/* string terminator (end of string).    */
/* Returns the index of the beginning    */
/* of the substring, -1 if not found.    */
/*                                       */
/* Development History:                  */
/*   Begun: 11/21/85 - Todd King         */
/*            Under GH06 support.        */
/*   Revised: 2/19/87 - Marco Zagha      */
/*            Under GG44 support.        */
/*                                       */
/*  Version:                             */
/*     %W%      (UCLA/IGPP)     %G%      */
/*---------------------------------------*/

int 
findstr (char substr[], char in[], int xtertog)
{
  int j,n,end,tend;
  unsigned int g_flag,toggle;

  end=strlen(in);
  if (end == 0) return (-1);
  tend=strlen(substr);
  g_flag=1;
  j=(-1);
  toggle=0;
  while(g_flag && j< end)
  {
    j++;
    while(in[j] == xtertog && in[j+1] == xtertog) /* consequtive xtertog */
    {
      j+=2; /* skip twin quotes */
    }
    if(in[j] == xtertog) {if(toggle==0) toggle =1; else toggle=0;}
    if(!toggle) /* search for deliminator */
    {
      if(in[j] == substr[0])  /* If first xter matches check rest */
      {  
        n=1;
        while(n<tend && in[j+n] == substr[n]) n++; /*check all xters in delim*/
        if (n == tend) g_flag=0; /* If all found exit */
      }  
    }  
  }  
  if(j==end) return(-1);
  else return(j);
}

