/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

/*--RCOMFILE -------------------------------------
 Function to read a command file and return a
 valid command line. Comments in the command
 file are ignored (designated by beginning a
 with a slash-star combination). If the flag
 chk_prefix is specified then the deliminator
 DELIM is used to parse command lines and the
 prefix portion is compared to PREFIX. If they
 match then the remaining portion of the command
 line is returned as a valid command line.
 The function returns 1 if a valid command was
 found and a -1 if end of file has been
 encountered.

  Entry requirements:
     COMFILE: A preopened file pointer
     CMDSTR: A char variable to place command
             string.
     RECL  : The number of bytes to read from
             the file, typically=sizeof(CMDSTR)
     DELIM : Contains the deliminator to use for
             seperating the prefix from the
             command. Applicable only if
             CHK_PREFIX is true.
     PREFIX: Contains the prefix to which
             indentifies a valid command.
             Appilicable only if CHK_PREFIX=true
 CHK_PREFIX : true is a prefix is to be searched
             for, false otherwise.

 NOTE: If chk_prefix is false the next none
       commented command line is returned

   Begun: 12/5/85 - Todd King
          Under GH06 support.

  Version:
     %W%      (UCLA/IGPP)     %G%
-------------------------------------------------*/

#include <stdio.h>

rcomfile(FILE *comfile, char cmdstr[], char delim[], char prefix[], unsigned int chk_prefix, unsigned int recl)
{
  unsigned int again;
  int end;
  char *halves[2];

  again=1;  /* preset */
  scaseup(prefix);  /* insure standard format */
  while(again)
  {
    if(fgets(cmdstr,recl,comfile) == NULL) {return(-1);} /* EOF */
    end=strlen(cmdstr)-1;
    if(cmdstr[end] == '\n') cmdstr[end]='\0'; /* remove newline xter */
    trimspc(cmdstr);
    parse(cmdstr,halves,"/*",2);
    if(strlen(cmdstr) != 0)   /* Not commented or null line */
    {
      if (chk_prefix) /* check command string for designated prefix */
      {  
        parse(cmdstr,halves,delim,2);
        trimspc(halves[0]);
        scaseup(halves[0]);
        if(strcmp(prefix,halves[0]) == 0) /* found a good command */
        {
          strcpy(cmdstr,halves[1]);
          return(1);
        }
      }  
      else return(1);  /* command line read and parsed */
    }
  }  
}
