/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

/*-- UNQUOTE2 ------------------------------------*/
/* Removes the first most and last most quotes in */
/* a string of characters. Returns the string     */
/* the quotes removed.                    .       */
/*                                                */
/* This function differs from the unquote()       */
/* function in that unquote2() only removes quotes*/
/* if the first character and the last character  */
/* are quotes.   No other quotes are removed.     */
/*                                                */
/* Entry requirements:                            */
/*    STRING : The string to remove the quotes    */
/*                                                */
/* Development History:                           */
/*   Begun: 4/26/88 - Marco Zagha                 */
/*          Under GY49 support.                   */
/*                                                */
/*  Version:                                      */
/*     %W%      (UCLA/IGPP)     %G%               */
/*------------------------------------------------*/
int 
unquote2 (char *s)
{ 
  int len, j; 
    
   len = strlen(s);
   if (len <= 1) return;
   if ((s[0] == '"') && (s[len-1] == '"')) {
     for (j = 0; j < len-1; j++) {   
        s[j] = s[j+1]; 
     }
     s[len-2] = '\0';
   }
}


