/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*--GETCOLVAL --------------------------
 Gets the requested column value.
 returns 0 if the column is not found.
 this is not to be considered an
 error status since zero is also a
 valid return.

 Entry requirements:
    COLNAME: The short column name for
             which its value is to be
             returned.

 Developement History:
   Begun: 12/21/92 - Gilbert Hyatt
---------------------------------------*/

#include "pipec.h"

double 
GetColVal (int bufnum, char *colname)
{
  extern BUFFER_HEAD _Rbuffer;
  RECPTR             *ptr;
  char               *data;


  double buffgetcolval();

  if (bufnum < 0)              return(infinity());
  if (bufnum > _Rbuffer.nrecs) return(infinity());

  if (bufnum == 0)   
    data = _Rbuffer.working->data;
  else {
    ptr  = BufGetRecPtrOf(bufnum);
    data = BufMapData(ptr);
  }  /* end of if-else */

  return(buffgetcolval(data, colname));
}  /* end of GetColStr() */


