/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- COLNUM --------------------------
 Returns the number of the column
 correspnding to the given column
 name. returns -1 if column is not
 found. Always returns the first
 occurance of a given column name.

 Entry requirements:
  COLNAME: The short column name to
           determine its index.

 Developemnt History:
    Begun: 2/21/86 - Todd King
       Under GH06 support.
     Edited:04/14/94 - Gilbert Hyatt
       Now uses pipec.h as entry
       point into the library.
------------------------------------*/

#include "pipec.h"

int 
colnum (char colname[])
{
  int dnum,i,last;
  char temp[9];

  extern DESC Desc[];
  extern int Ndesc;

  strncpy(temp, colname, 8);	/* Only first 8 valid */
  temp[8] = '\0';
  last = strlen(temp);
  for(i = last; i < 8; i++) temp[i]=' ';
  temp[8] = '\0';
  dnum = 0;
  while(strcmp(temp, Desc[dnum].shortcol) != 0) 
  {
    dnum++;
    if(dnum > Ndesc) return(-1); 			/* Not found */
  }
  dnum++;			/* Incriment to starting base of 1 */
  return(dnum);
}

