/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */

/*-- EXCOLNUM ------------------------
 Returns the number of the first
 EXISTING (not removed) column
 corresponding to the given column
 name or -1 if one is not found.

 Entry requirements:
  COLNAME: The short column name to
           determine its index.

 Development History:
    Begun: 8/6/86 - Marco Zagha
             (from function colnum)
            Under GG44 support.
  Edited:04/14/94 - Gilbert Hyatt
    Now uses pipec.h as entry point
    into the library.
------------------------------------*/

#include "pipec.h"

int 
excolnum (char colname[])
{
  int dnum, i, last, colnum(), checkflag();
  char temp[9];

  extern DESC Desc[];
  extern int Ndesc;

  if (strlen(colname) > 8) colname[8]='\0';    /* Put into proper format */
  strcpy(temp, colname);
  last = strlen(temp);
  for (i=last; i<8; i++) temp[i]=' ';
  temp[8] = '\0';
  dnum = 0;
  while(!(checkflag(OUTPUT, dnum)) || (strcmp(temp,Desc[dnum].shortcol) != 0))
  {
    dnum++;
    if (dnum > Ndesc) return(-1); 			/* Not found */
  }
  dnum++;			/* Increment to starting base of 1 */
  return(dnum);
}
