/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
	%W%	(UCLA, IGPP) %G%
 */

/*-- ISFLAG -----------------------------
 Returns 1 if the column is a flag;
 0 otherwise.

 Entry requirements:
    COLNAME: The short column name to
             compare with the
             appropriate flag value.

 Development History:
   Begun: 7/28/86 - Marco Zagha
            Under GG44 support.
   Modified: 7/29/88 - Marco Zagha
            (Nan and infinity check)
            Under GY49 support.
  Edited:04/14/94 - Gilbert Hyatt
    Now uses pipec.h as entry point
    into the library.
---------------------------------------*/

#include <string.h>
#include <math.h>
#include "pipec.h"

int 
isflag (char colname[])
{

#define ERRORMARGIN	1.0e+35   /* due to roundoff errors of floats */

  extern DESC Desc[];

  int dnum, j, retval;
  char tempstr[1024];
  int colnum();
  double getcolval();
  double val;
  char *getcolstr();

  dnum = colnum(colname);
  dnum--;					/* Adjust count */
  if (dnum < 0) return (0);			/* Not found */
  switch(Desc[dnum].type)
  {
    case 'I':
	      val = getcolval(colname);
	      retval = (((int) val >= FLAGINT) || isnan(val) || isinf(val));
	      break;
    case 'R':
	      val = getcolval(colname);
	      retval = (((float) val >= (FLAGREAL-ERRORMARGIN)) ||
			isnan(val) || isinf(val));
	      break;
    case 'T':
    case 'D':
	      val = getcolval(colname);
	      retval = ((val >= FLAGDOUBLE) || isnan(val) || isinf(val));
	      break;
    case 'A': 
	      strcpy(tempstr, getcolstr(colname));
	      if (tempstr[0] != '?')
		retval = 0;
	      else    /* flag if all chars after '?' are spaces */
	        for (j = 1, retval = 1; tempstr[j] != '\0' && retval; j++)
		  if (tempstr[j] != ' ') retval = 0;
	      break;
  }
  return (retval);
}
