/*---------------------------------------------------------------*/
/*   Copyright (c) 1991 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
*/

/*-- dfs_set_buffer_record ---------------------------------------------
   Makes a specific record in a record buffer the current
   This call does not update the DFS working record. You may
   set to any record within the buffer whether or not there is
   active information in the record.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())
       recnum: The number of the record to make the current
	       working record.

   Development History
      Begun: 04/12/91 - Todd King
      Edited:04/14/94 - Gilbert Hyatt
        Now uses pipec.h as entry point into the library.
---------------------------------------------------------------*/

#include "pipec.h"

extern char *Rbuffer;	/* DFS working record */

int 
dfs_set_buffer_record (DFS_RECBUFF *buffer, int recnum)
{
   char *ptr;
   int real_rec;

   if(buffer == NULL) return(FALSE);
   if(recnum < 0 || recnum >= buffer->max_recs) return(FALSE);

   real_rec = buffer->first_rec + recnum;
   if(real_rec >= buffer->max_recs) { 
      real_rec -= buffer->max_recs; 
   }

   buffer->cur_rec = recnum;

   return(TRUE);
}

