/*---------------------------------------------------------------*/
/*   Copyright (c) 1989 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)ffio.h	1.9   (UCLA, IGPP)    07 Sep 1994
*/
/*-------------------------------------------------------------
  Definitions for flatfile I/O.

  Development History:
  Begun: 10/31/89 - Todd King
  Edited:09/20/93 - Gilbert Hyatt
         added iformation for COMPOUND file opens.
--------------------------------------------------------------*/
#ifndef _FFIO_
#define _FFIO_	1

#include <stdio.h>
#include "sql.h"	/* For SQL_FIELD */

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* Definitions for descriptors */

/* Maximum lengths */

#define FF_LNAME	32
#define FF_SNAME	 8
#define FF_UNITS	16
#define FF_TYPE		 1
#define FF_WIDTH	 3
#define FF_SORT		 2
/*                  --------      */
#define FF_DESCWIDTH	62 + sizeof('\n')

#define FF_MAX_ABS_LINE	80
#define FF_MAX_FIELD_WIDTH	999	/* Largest with 3 digits (FF_WIDTH) */

#define MAX_FILENAME	512

#define FF_HED_FNAME	8
#define FF_HED_PATH	36
#define FF_HED_CDATE	30	/* Must be at least 26 */
#define FF_HED_OWNER	20
#define FF_HED_NCOLS	3
#define FF_HED_NRECS	5

/* Definitions for working with flat files */

#define FF_FAILURE	0
#define FF_SUCCESS	1

/* Status field identifiers */

#define FF_DES	1
#define FF_DAT	2
#define FF_HED	4
#define FF_ABS	8
/*             --- */
#define FF_ALL	15	/* All components (sum of identifiers) */
#define FF_OPENED_BEFORE	16

/* Parameters for insert and delete variables */

#define FF_DELETE_INC	512	/* incriments delete lists are increased */
#define FF_INSERT_INC	512	/* incriments insert lists are increased */

/* Parameters for binding variables */

#define FF_BIND_INC	64  /* The step at which the bind list is increased */
#define FF_BIND_WRITE	1
#define FF_BIND_READ	2

/* Types used in the bind calls */
/* NOTE: Any time there are additions or subtractions from this
	 list the function ffcheck_type() must be updated.
*/
#define FF_INT		'I'
#define FF_FLOAT	'R'
#define FF_DOUBLE	'D'
#define FF_TIME		'T'
#define FF_ALPHA	'A'

/* Style of flatfile */
#define FF_STYLE_COMPONENT      1
#define FF_STYLE_VIRTUAL	2
#define FF_STYLE_COMPOUND	3

/* Type of flatfile */
#define FF_TYPE_HIGHER          1
#define FF_TYPE_LOWER           2
#define FF_TYPE_FLOWFILE        3


/* Identifier for virtual flatfiles */

#define FF_VIRTUAL_MAGIC_COOKIE "TYPE=UCLA/IGPP-VIRTUAL-FF-1.0\n"

/* Open style codes */

#define FF_OPEN_READ	1
#define FF_OPEN_WRITE	2
#define FF_OPEN_APPEND	3
#define FF_OPEN_UPDATE	4

typedef struct {
   unsigned long cnt;
   unsigned long max;
   unsigned long *recnum;
} FF_DELETE;

typedef struct {
   unsigned long recnum;
   char *data;
} FF_RECORD;

typedef struct {
   unsigned long cnt;
   unsigned long max;
   FF_RECORD *record;
} FF_INSERT;

typedef struct {
    char fname[FF_HED_FNAME];
    char path[FF_HED_PATH];
    char cdate[FF_HED_CDATE];
    char owner[FF_HED_OWNER];
    char ncols[FF_HED_NCOLS];
    char nrecs[FF_HED_NRECS];
} FF_HED_REC;

/* For application level definitions of descriptors */
typedef struct {
  char longname[FF_LNAME + 1];
  char shortname[FF_SNAME + 1];
  char units[FF_UNITS + 1];
  char type;
  unsigned int width;
  int  sort;
} FF_DESC;

/* For internal definitions of descriptors */
typedef struct _FF_FULL_DESC_ {
  char longname[FF_LNAME + 1];
  char shortname[FF_SNAME + 1];
  char units[FF_UNITS + 1];
  char type;
  unsigned int width;
  int  sort;
  unsigned long offset;
  struct _FF_FULL_DESC_ *next;
} FF_FULL_DESC;

typedef struct {
  char *vaddr;
  unsigned type;
  unsigned long cidx;
  unsigned long size;
} FF_BINDER;

typedef struct {
  FILE *fptr;
} VIRTUAL_INFO;

typedef struct {
  char *fname_list[MAX_FILENAME];
  int  numfiles;
  int  currentfile;
} COMPOUND_INFO;

typedef struct {
  int style;
  VIRTUAL_INFO  vinfo;
  FILE *desc;
  FILE *abs;
  FILE *hed;
  FILE *data;
  FF_FULL_DESC *descdb;
  unsigned long ncols;
  unsigned long reclen;
  unsigned long nrecs;
  unsigned long cur_recnum;
  unsigned int open_style;
  unsigned open_status;
  char *rec_buff;
  char fname[MAX_FILENAME + 1];
  unsigned flags;
  unsigned long bindcnt;
  unsigned long bindmax;
  FF_BINDER *bindlist;
  FF_DELETE dlist;
  FF_INSERT ilist;
  COMPOUND_INFO compound;
  int           type;
} FLATFILE;

typedef double TIME;

/* Macro functions */

#define ffclose(ffptr)	ffclose_select(ffptr, FF_ALL)
#define ffwrite(s, n, t, f) fwrite(s, n, t, f->data); f->nrecs += t
#define ffset_col_val(f, c, v)	_ffset_col_val(f, c, (double) v)

/* Function declarations */

FLATFILE*     ffcreate();
FLATFILE*     ffopen();
FLATFILE*     ffopen_select();
double        ffget_col_val();
char*         ffget_col_str();
FF_FULL_DESC* ffget_desc();
char*         ffcol_units();
char*         ffcol_lname();
char*         ffcol_sname();

FLATFILE*     nffopen_select();
FLATFILE*     lffopen_select();
int           ffopen_csegment();

int		ffSQLReadScalar();
SQL_FIELD	*ffSQLFieldName();
FF_DESC		*ffnull_desc();
int			ffcheck_type(); 
int			ffbind();       
int			ffmakedesc();
int			ffmove_to_rec();
int			ffopen_segment();
int			ffupdate();
int			ffwrite_desc();
int			ffwrite_abs();
int			ffexists();
int			ffmake_path();
int			ffadd_desc();
int			ffcompare();
int			ffclose_select();
int			_ffset_col_val();
int			ffset_col_str();
int			ffset_col_flag();
int			ffread_rec();
int			ffpad_str();
int			ffncol();
int			ffscol_index();
int			ffcol_type();

#endif /* _FFIO_ */
