/*----------------------------------------------------------------
   Copyright (c) 1992 Regents of the University of California
                 All Rights Reserved

   Development History:
      Begun: 12/02/91 - Todd King

   Version:
      @(#)sql.h	1.3   (UCLA/IGPP)   06 Jan 1994
------------------------------------------------------------------*/
/*------------------------------------------------------------
   Structures for compiling SQL queries.
------------------------------------------------------------*/

#ifndef _sql_h_
#define _sql_h_	1

#include "list.h"
#include "pattern.h"

enum { SQL_FUZZY_PLUS = 1, SQL_FUZZY_MINUS, SQL_FUZZY_PLUS_MINUS};

typedef struct SQL_LIST {
   char *text;
   struct SQL_LIST *next;
} SQL_LIST;

typedef struct SQL_TABLE {
   char *name;
   SQL_LIST *fields;
   struct SQL_TABLE *next;
} SQL_TABLE;

typedef struct SQL_FIELD {
   char *table;
   char *column;
   struct SQL_FIELD *next;
} SQL_FIELD;

typedef struct SQL_SCALAR {
   int type;
   SQL_FIELD *field;
   int ival;
   double dval;
   char *text;
   PATTERN *pattern;
   struct SQL_SCALAR *fuzzy_plus;
   struct SQL_SCALAR *fuzzy_minus;
} SQL_SCALAR;

typedef struct SQL_ALIAS {
   char *text;
   char *alias;
   struct SQL_ALIAS *next;
} SQL_ALIAS;

typedef struct SQL_ASSIGNMENT{
   char *field;
   SQL_SCALAR *scalar;
   struct SQL_ASSIGNMENT *next;
} SQL_ASSIGNMENT;

typedef struct SQL_VALUE {
   SQL_SCALAR *value;
   struct SQL_VALUE *next;
} SQL_VALUE;

typedef struct SQL_QUERY {
   int action;
   char *table;
   SQL_FIELD *field;
   SQL_ALIAS *alias;
   SQL_VALUE *value;
   LIST_NODE *constraint;
   SQL_ASSIGNMENT *assignment;
} SQL_QUERY;

typedef struct SQL_VIEWS {
   SQL_TABLE *tables;
   SQL_QUERY *query;
} SQL_VIEWS;

/* External global definitions */
extern SQL_FIELD *SQL_field_list;       /* Defined in "sql_field.c" */
extern SQL_FIELD *SQL_last_field;       /* Defined in "sql_field.c" */
 
extern SQL_ALIAS *SQL_alias_list;       /* Defined in "sql_alias.c" */
extern SQL_ALIAS *SQL_last_alias;       /* Defined in "sql_alias.c" */
  
extern LIST_NODE *SQL_constraint_list;     /* Def in "sql_parser.y" */
   
extern SQL_VALUE *SQL_value_list;     /* Def in "sql_value.c" */
extern SQL_VALUE *SQL_last_value;     /* Def in "sql_value.c" */
   
extern SQL_ASSIGNMENT *SQL_assignment_list;     /* Def in "sql_assignment.c" */
extern SQL_ASSIGNMENT *SQL_last_assignment;     /* Def in "sql_assignment.c" */
    
extern SQL_QUERY *SQL_query;            /* Defined in "sql_query.c" */

/* Function definitions */
SQL_FIELD *sql_make_field();
SQL_FIELD *sql_push_field();
SQL_FIELD *sql_last_field();
SQL_ALIAS *sql_make_alias();
SQL_ASSIGNMENT *sql_make_assignment();
SQL_VALUE *sql_make_value();
SQL_QUERY *sql_make_query();
SQL_SCALAR *sql_make_scalar();
LIST_NODE *sql_make_scalar_node();
SQL_VIEWS *sql_make_views();
SQL_VIEWS *sql_parse_query();
SQL_VIEWS *sql_build_views();
SQL_TABLE *sql_make_table();
SQL_TABLE *sql_push_table();
SQL_TABLE *sql_find_table();
SQL_LIST *sql_make_list();
SQL_LIST *sql_push_list();
SQL_LIST *sql_find_list();
char **sql_table_list();

/* Action codes */
#define SQL_ACTION_SELECT 1
#define SQL_ACTION_INSERT 2
#define SQL_ACTION_UPDATE 3
#define SQL_ACTION_DELETE 4

/* Operator codes */

#define SQL_OP_PLUS		1
#define SQL_OP_MINUS		2
#define SQL_OP_MULT		3
#define SQL_OP_DIV		4
#define SQL_OP_AND		5
#define SQL_OP_OR		6
#define SQL_OP_BETWEEN		7
#define SQL_OP_NOT		8
#define SQL_OP_GREATER_THAN	9
#define SQL_OP_LESS_THAN	10
#define SQL_OP_NOT_EQUAL	11
#define SQL_OP_EQUAL		12
#define SQL_OP_GREATER_EQUAL	13
#define SQL_OP_LESS_EQUAL	14

/* Type codes for scalar values */

#define SQL_TYPE_FIELD		1
#define SQL_TYPE_FUNCTION	2
#define SQL_TYPE_INT		3
#define SQL_TYPE_DOUBLE		4
#define SQL_TYPE_TEXT		5
#define SQL_TYPE_DATE_TIME	6
#define SQL_TYPE_OPERATOR	7

#endif /* _sql_h_ */
