/*---------------------------------------------------------------*/
/*   Copyright (c) 1993 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-----------------------------------------------------------------
  Miscellaneous support functions for binary conversion.
  Whenever a new format is added the following things need to be
  done in order to use these support functions.

    1. Define a unique token value in BC.h for the format.
       The token name should be the name of the format 
       prefixed with "BCFormat". A toke should not have a negative
       value.
    2. Modify the token text name list in BC.h to have the format name
       at the location in the list which corresponds to its token 
       number.
    3. Modify the switch statement in BCSetFormat() so that
       it has a case for the token.
  
  Development History:
    Begun: 01/12/94 - Todd King

  Version:
      %W%   (UCLA/IGPP)   %G%
-----------------------------------------------------------------*/
#include "BC.h"

/*-----------------------------------------------------------------
  Sets the format translation to the format associated with the
  given format token.

  Return Value:
     BCSuccess : If the token was for a known format.
     BCFailure : If the token was not for a known format.

  Development History:
    Begun: 01/12/94 - Todd King

  Version:
      %W%   (UCLA/IGPP)   %G%
-----------------------------------------------------------------*/
/* Supported formats */
void BCNullFormat();
void BCSunFormat();
void BCHP1000Format();
void BCMSBFormat();
void BCPCFormat();
void BCIBM370Format();
void BCVAXFormat();

int 
BCSetFormat (int token)
{
   switch(token) {
      case BCFormatNULL:
	 BCNullFormat();
	 break;
      case BCFormatSun:
	 BCSunFormat();
	 break;
      case BCFormatHP1000:
	 BCHP1000Format();
	 break;
      case BCFormatIBM370:
	 BCIBM370Format();
	 break;
      case BCFormatMSB:
	 BCMSBFormat();
	 break;
      case BCFormatPC:
	 BCPCFormat();
	 break;
      case BCFormatVAX:
	 BCVAXFormat();
	 break;
      default:
	 return(BCFailure);
   }
   return(BCSuccess);
}

/*-----------------------------------------------------------------
  Converts a text string to a format token. This function converts
  the passed string to uppercase during the comparison process.

  Return Value:
     -1 : If the text name has not corresponding format token.
     otherwise : The token for the given format.

  Development History:
    Begun: 01/12/94 - Todd King

  Version:
      %W%   (UCLA/IGPP)   %G%
-----------------------------------------------------------------*/
int scaseup();
int	KeywordMatch();

int 
BCFormatToken (char format[])
{
   scaseup(format);
   return(KeywordMatch(format, BCFormatList));
}
