/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-----------------------------------------------------------------
  Miscellaneous support functions for IEEE binary conversion.

  Development History:
    Begun: 03/20/92 - Todd King

  Version:
      %W%     (UCLA/IGPP)    %G%
-----------------------------------------------------------------*/
#include "BC.h"
#include <math.h>	/* For quiet_nan() and isnan() */

int 
BCSetIEEEFloatNaN (BCIEEEFloat *f)
{
   if(f == NULL) return(0);

   f->field.sign = 0;
   f->field.exponent = 257;
   f->field.mantissa1 = 0x007f;
   f->field.mantissa0 = 0xffff;
   return(1);
}

int 
BCIsIEEEFloatNaN (BCIEEEFloat *f)
{
   if(f == NULL) return(0);

   if(f->field.sign == 0 &&
      f->field.exponent == 257 &&
      f->field.mantissa1 == 0x007f &&
      f->field.mantissa0 == 0xffff) {
      return(1);
   }
   return(0);
}

int 
BCDumpIEEEFloat (BCIEEEFloat *f)
{
   int4 mantissa;

   printf("sign    : %d\n", f->field.sign ? 1 : 0);
   printf("exponent: %d\n", f->field.exponent);
   mantissa = (f->field.mantissa1 << 16) + f->field.mantissa0;
   printf("mantissa: %d (0x%08x)\n", mantissa, mantissa);
   return(1);
}

int 
BCSetIEEEDoubleNaN (BCIEEEDouble *f)
{
   if(f == NULL) return(0);

   f->field.sign = 0;
   f->field.exponent = 2047;
   f->field.mantissa3 = 0x000f;
   f->field.mantissa2 = 0xffff;
   f->field.mantissa1 = 0xffff;
   f->field.mantissa0 = 0xffff;
   return(1);
}

int 
BCIsIEEEDoubleNaN (BCIEEEDouble *f)
{
   if(f == NULL) return(0);

   if(f->field.sign == 0 &&
      f->field.exponent == 2047 &&
      f->field.mantissa3 == 0x000f &&
      f->field.mantissa2 == 0xffff &&
      f->field.mantissa1 == 0xffff &&
      f->field.mantissa0 == 0xffff ) {
      return(1);
   }
   return(0);
}

int 
BCDumpIEEEDouble (BCIEEEDouble *f)
{
   int4 mantissa;

   printf("sign         : %d\n", f->field.sign ? 1 : 0);
   printf("exponent     : %d\n", f->field.exponent);
   mantissa = (f->field.mantissa1 << 16) + f->field.mantissa0;
   printf("low mantissa : %d (0x%08x)\n", mantissa, mantissa);
   mantissa = (f->field.mantissa3 << 16) + f->field.mantissa2;
   printf("high mantissa: %d (0x%08x)\n", mantissa, mantissa);
   return(1);
}
