/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)compare.c	1.1   (UCLA/IGPP)   11 Dec 1992
 */

/*-- COMPARE ------------------------------------------------------*/
/* Rotuine to return whether one string is less than, equal to or  */
/* greater than another. This routine considers any string shorter */
/* then another string to be less than the other. This is not true */
/* with a straight lexographic comparision (strcmp).               */
/*                                                                 */
/*  Entry Requirements:                                            */
/*    s1: the string to compare to s2.                             */
/*    s2: the string to compare to s1.                             */
/*                                                                 */
/*  Returns: < 0 if less than, 0 if equal and > 0 if greater than. */
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 01/28/87 - Todd King                                  */
/*                   Under GG44 support                            */
/*-----------------------------------------------------------------*/
#include <string.h>

compare(s1, s2)
char **s1, **s2;
{
  int ret;

  ret=strcmp(*s1, *s2);
  if(strlen(*s1) < strlen(*s2)) ret=(-1);
  return(ret);
}

