/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)def_dir.c	1.1   (UCLA/IGPP)   11 Dec 1992
 */
/*-- HDEF_HOME_DIR ------------------------------------------------*/
/* Gets the default home directory for the given user name.        */
/* Searches  both the password file and the yellow pages files for */
/* an entry                                                        */
/*                                                                 */
/*  Entry Requirements:                                            */
/*    name: the name to search for.                                */
/*    hdir: string to hold the home directory for name             */
/*                                                                 */
/*  Returns:                                                       */
/*    -1 if no entry found, 0 if found with 'hdir' filled with the */
/*    path.                                                        */
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 02/23/87 - Todd King                                  */
/*                   Under GG44 support                            */
/*-----------------------------------------------------------------*/
#include <stdio.h> 
#include <string.h>
#ifdef _MSDOS
/* nothing */
#else
#include <pwd.h>
#endif

def_home_dir(name, hdir)
char *name, *hdir;
{
#ifdef _MSDOS
  strcpy(hdir, "");
#else
  struct passwd *getpwnam();

  struct passwd *pwp;

  if((pwp = getpwnam(name)) == NULL) return(-1);
  strcpy(hdir, pwp->pw_dir);  
#endif
  return(0);
}
