/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- CLEANPARSE ---------------------------------------------------*/
/* Performs a regular parse, then cleans up the parsed parts by    */
/* trimming leading and trailing white space then removing all     */
/* blank elements.                                                 */
/*                                                                 */
/*  Entry Requirements:                                            */
/*    Same as for parse.                                           */
/*                                                                 */
/*    string: String to parse                                      */
/*    part: array of pointers which will point to the parsed parts */
/*          of the string.                                         */
/*    delim: The deliminator to use for parseing                   */
/*    maxpart: The maximum number of parts to parse for.           */
/*                                                                 */
/*  Returns:                                                       */
/*    The number of parts in the string.                           */
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 02/19/87 - Todd King                                  */
/*          Under GG44 support.                                    */
/*                                                                 */
/*  Version:                                                       */
/*     @(#)clnparse.c	1.1      (UCLA/IGPP)     03 Mar 1992                                */
/*-----------------------------------------------------------------*/
int parse();
int trimspc();
int packlist();

cleanparse(string, part, delim, maxpart)
char string[];
char *part[];
char delim[];
int maxpart;
{
  int i, npart;

  npart=parse(string, part, delim, maxpart);
  for (i=0; i< npart; i++) trimspc(part[i]);
  npart = packlist(part, npart);
  return(npart);
}

