/*---------------------------------------------------------------*/
/*   Copyright (c) 1994 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- NSTRCAT ----------------------------------------------------
 This function appends up to NCHARS characters of SOURCE
 to DEST.  This function is almost identical to strncat,
 except that NCHARS is the maximum size of DEST and
 NCHARS - strlen(DEST) - 1 is the maximum number of characters 
 appended from SOURCE to DEST. 

 ENTRY REQUIREMENTS:
   DEST:   Destination String
   SOURCE: Source String
   NCHARS: Maximum number of characters to copy

 RETURN VALUES:
   Returns a pointer to the result

 Development History:
   Begun: 07/05/94 - Todd Kinga

  Version:
     @(#)nstrcat.c	1.2   (UCLA/IGPP)   28 Feb 1995
-----------------------------------------------------------------*/
#include <string.h>

char *
nstrcat(dest, source, nchars)
char *dest;
char *source;
int nchars;
{
   int n = nchars - strlen(dest) - 1;

   if(n > 0) strncat(dest, source, n);
   return(dest);
}
