
/*----------------------------------------------------------------
   Frees all memory associated with a PATTERN link list.

   Entry Requirements:
      none.

   Return Value:
      none

   Development History:
      Begun: 03/05/92 - Todd King

   Version:
      @(#)p_free.c	1.2      (UCLA/IGPP)    15 Mar 1993
------------------------------------------------------------------*/
#include <malloc.h>	/* For free() */
#include "pattern.h"

void
pattern_free(pattern)
PATTERN *pattern;
{
   PATTERN *p;
   PATTERN *next;

   if(pattern == NULL) return;

   for(p = pattern; p != NULL; p = next) {
     next = p->next;
     switch(p->type) {
        case PATTERN_TYPE_FIXED:
           if(p->text != NULL) free(p->text);
           break;
     }
     free(p);
   }
   return;
}
