/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/

/* -- UNESCAPE ---------------------------------------------- */
/* Removes a special character (escape character) as follows: */
/* All escape characters are removed from the string except   */
/* for two consequtive escape characters which are compressed */
/* into a single escape character.                            */
/*                                                            */
/* ENTRY REQUIREMENTS:                                        */
/*   STR:  The string possibly containing the escape char.    */
/*   CH:   The escape character                               */
/*                                                            */
/* RETURN VALUES:                                             */
/*   1 if any changes were made to the string; 0 otherwise.   */
/*                                                            */
/* Development History:                                       */
/*     Begun:  2/6/87  - Marco Zagha                          */
/*         Under GG44 support.                                */
/*     Modified: 02/03/92 - Todd King                         */
/*         Streamlined.                                       */
/*                                                            */
/*  Version:                                                  */
/*     @(#)unescape.c	1.1      (UCLA/IGPP)     03 Mar 1992                           */
/* ---------------------------------------------------------- */
unescape(str, ch)
char	str[];
char	ch;
{
   char *s;          /* 'read' pointer  */
   char *t;  		/* 'write' pointer */
   int change_made = 0;

   for(t = s = str; *s != '\0'; s++, t++) {
      if(*s == ch) {
         s++;
         change_made = 1;
      }
      *t = *s;
   }
   *t = '\0';
   return(change_made);
}
