/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- UNQUOTE -------------------------------------*/
/* Removes the first most and last most quotes in */
/* a string of characters. Returns the string     */
/* the quotes removed. Always equates to 0.       */
/*                                                */
/* Entry requirements:                            */
/*    STRING : The string to remove the quotes    */
/*                                                */
/*   Development History:                         */
/*      Begun: 12/7/85 - Todd King                */
/*         Under GH06 support.                    */
/*      Edited: 02/15/94 - Gilbert Hyatt          */
/*         Change strings calls to string calls   */
/*                                                */
/*  Version:                                      */
/*     @(#)unquote.c	1.2      (UCLA/IGPP)     15 Feb 1994               */
/*------------------------------------------------*/

#include <string.h>
#include <stdio.h>

unquote(string)
char string[];
{
  int j,n,end;
  char *tmp_ptr;

  end=strlen(string);
  for(j=0;j<end;j++) /* search for and reduced twin quotes */
  {
    if(string[j]=='"' && string[j+1]=='"')
    {
      for(n=j+1;n<end;n++) string[n]=string[n+1];
      end--;  /* adjust end of string */
      j++; /* point to next xter */
    }   
  }
  if((tmp_ptr=strchr(string,'"')) != NULL) /* remove first quote */
  {
    end=strlen(tmp_ptr);
    for(j=1;j<=end;j++) tmp_ptr[j-1]=tmp_ptr[j]; /* compress */
  }
  if((tmp_ptr=strrchr(string,'"')) != NULL) /* remove last quote */
  {
    end=strlen(tmp_ptr);
    for(j=1;j<=end;j++) tmp_ptr[j-1]=tmp_ptr[j]; /* compress */
  }
  return(0);
}

