/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      @(#)BufAdvanceThru.c	1.2  (UCLA, IGPP) 20 Apr 1994 
*/
/*-------------------------- ------------------------------------
  BufAdvanceThru(int start, int finish) -
    This can be use in a while loop to loop thru the buffer.
    example:
      while(BufAdvanceThru(1, 15)) { ... }
  
  Return:
    Present record number.

  Entry Requirements:
    int start
    int finish
      Both with in the range on the number of items in the buffer list,
      if not they are set to  1 or last record respectively.

  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
---------------------------------------------------------------*/
#include "pipec.h"

 
BufAdvanceThru(start, finish)
int start;
int finish;
{
  extern BUFFER_HEAD  _Rbuffer;
  static int          present_rec = 0;

  finish = (finish > _Rbuffer.nrecs)?_Rbuffer.nrecs:finish;
  start  = (start < 1)?1:start;
  present_rec  = (present_rec == 0)?start:present_rec +1;
  present_rec  = (present_rec > finish)?0:present_rec;

  BufUseRec(present_rec);
  return(present_rec);
}  /* end of BufAdvanceThru() */
    

