/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)checkflag.c	1.3  (UCLA, IGPP) 20 Apr 1994 
 */
/*-- CHECKFLAG -------------------------------*/
/* Checks to see if a specified flag is set   */
/* in the descriptor structures flag variable.*/
/* Returns true (1) if it is and false (0) if */
/* it is not.                                 */
/*                                            */
/* Entry requirements:                        */
/*   FLAG: Flag or composite flag to check    */
/*         against those set for the column.  */
/*   COL: The column to check the flags       */
/*        against.                            */
/*                                            */
/* NOTE:  the column index passed to          */
/*        checkflag should use zero-indexing. */
/*                                            */
/* Development History                        */
/*   Begun: 7/9/86 - Todd King                */
/*     Under GH06 support.                    */
/*   Edited:04/14/94 - Gilbert Hyatt          */
/*     Now uses pipec.h as entry point into   */
/*     the library.                           */
/*--------------------------------------------*/
#include "pipec.h"

checkflag(flag,col)
unsigned int flag;
int col;
{
   extern DESC Desc[];

   if(Desc[col].flags&flag) return(TRUE);
   return(FALSE);
}
