/*---------------------------------------------------------------*/
/*   Copyright (c) 1991 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)nextrec_buff.c	1.4  (UCLA, IGPP) 20 Apr 1994 
*/
#include "pipec.h"

extern char *Rbuffer;	/* DFS working record */

/*-- dfs_buffer_nextrec ---------------------------------------------
   Returns the record number of where the next record will be written.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())

   Development History
      Begun: 04/12/91 - Todd King
      Edited:04/14/94 - Gilbert Hyatt
        Now uses pipec.h as entry point into the library.
---------------------------------------------------------------*/
dfs_buffer_nextrec(buffer)
DFS_RECBUFF *buffer;
{
   return((buffer->first_rec + buffer->nrecs) % buffer->max_recs);
}
