/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)plog.c	1.4  (UCLA, IGPP) 20 Apr 1994 
 */
/*-- PLOG ----------------------------------*/
/* Entry Requirements:                      */
/*   STRING: String to print                */
/*   TYPE: A character representing the type*/
/*        of message ('R','I', 'E')         */
/*                                          */
/* Developement History:                    */
/*    Begun: 2/6/87 - Marco Zagha           */
/*            Under GG44 support.           */
/*  Edited:04/14/94 - Gilbert Hyatt         */
/*    Now uses pipec.h as entry point       */
/*    into the library.                     */
/*------------------------------------------*/
plog(string, type)
char string[];
char type;
{
#include <sys/types.h>
#include <fcntl.h> 
#include "pipec.h"

  int ret;
  char *nl="\n";
  char tempstr[20];
#ifndef _MSDOS
  fcntl(errlog, F_SETLKW, F_WRLCK);   /* Obtain an exclusive lock */
#endif
  /* flock(errlog,LOCK_EX); */        /* Old                      */
  pdbMessageID++;
  sprintf(tempstr, "%c %d line %d: ", type, pdbMessageID, pdbFittingID);
  write(errlog, tempstr, strlen(tempstr));
  ret=write(errlog,string,strlen(string));
  write(errlog,nl,strlen(nl));
#ifndef _MSDOS
  fcntl(errlog, F_UNLCK, F_WRLCK);    /* Unlock file */
  /* flock(errlog,LOCK_UN); */        /* Old         */
#endif 
  if(ret > 0) ret=1;
  return(ret);
}
