/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)setcolval.c	1.3  (UCLA, IGPP) 20 Apr 1994 
 */

/*-- _SETCOLVAL ----------------------*/
/* Sets a column to the given value.  */
/* returns -1 if the value could not  */
/* set for whatever reason.           */
/* Will set a column only if it is    */
/* an output column (if it hasn't     */
/* been removed).  This function is   */
/* named _setcolval because of the    */
/* preprocessor macro definition:     */
/* #define setcolval(a,b)             */
/*           _setcolval(a,(double) b) */
/*                                    */
/* Entry Requirements:                */
/*   the short column name followed   */
/*   by the value to set the column   */
/*   to.                              */
/*                                    */
/* Development History:               */
/*   Begun:  2/21/86 - Todd King      */
/*            Under GH06 support.     */
/*   Update: 8/6/86  - Marco Zagha    */
/*            Under GG44 support.     */
/*   Update: 9/5/86  - Marco Zagha    */
/*            Under GG44 support.     */
/*   Update: 5/7/87  - Marco Zagha    */
/*            Under GG44 support.     */
/*------------------------------------*/
_setcolval(colname, value)
char	colname[];
double	value;
{
  extern char *Rbuffer;

  return(_buffsetcolval(Rbuffer, colname, value));
}
