/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)wdata.c	1.7  (UCLA, IGPP) 20 Apr 1994 
 */
/*-- WDATA ------------------------------*/
/* Writes a data record out according to */
/* the definitions contained in the      */
/* internal descriptor database.         */
/* The record is sent down the data pipe.*/
/*                                       */
/* Entry Requirements:                   */
/*   NONE                                */
/*                                       */
/* Developement History:                 */
/*  Begun: 2/21/86 - Todd King           */
/*            Under GH06 support.        */
/*  Modified: 11/4/86 - Todd King        */
/*            Under GH06 support.        */
/*  Modified: 7/20/88 - Todd King        */
/*         To bring in line with new     */
/*         structure definitions for     */
/*         buffer.                       */
/*            Under GH06 support.        */
/*  Modified: 01-14-94 - Gilbert         */
/*          changed bcopy to memmove     */
/*  Edited:04/14/94 - Gilbert Hyatt      */
/*    Now uses pipec.h as entry point    */
/*    into the library.                  */
/*---------------------------------------*/
wdata()
{
#include "pipec.h"

  extern char Outbuffer[];
  extern DESC Desc[];
  extern char *Rbuffer;
  extern int Ndesc;
  extern BUFFER Outrec;

  int j, offset;
  char *rptr;

  offset=0;
  rptr=Rbuffer;
  for(j=0;j<Ndesc;j++)	/* Build up the output record */
  {
    if(!checkflag(OUTPUT,j)) continue;	/* If not to output, ignore */
    memcpy(Outrec.buffer+offset, rptr+Desc[j].start, Desc[j].width);
    offset+=Desc[j].width;
  }
  if(Outrec.length == 0) {Outrec.length=offset;}
  return(putrec());
}

