/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)wdesc.c	1.6  (UCLA, IGPP) 20 Apr 1994 
 */
/*-- WDESC -----------------------------*/
/* Writes the information in the        */
/* internal database out the descriptor */
/* pipe.                                */
/*                                      */
/* Entry Requirements:                  */
/*  NONE                                */
/*                                      */
/* Developement History:                */
/* Begun: 2/21/86 - Todd King           */
/*            Under GH06 support.       */
/* Update: 3/3/87 - Marco Zagha         */
/*                  (descend() call)    */
/*            Under GG44 support.       */
/* Update: 6/8/87 - Marco Zagha         */
/*    (No descriptor pipe)              */
/*            Under GG44 support.       */
/* Update: 6/9/87  - Marco Zagha        */
/*      (Check to make sure descriptors */
/*       have not been written out)     */
/*            Under GG44 support.       */
/*  Edited:04/14/94 - Gilbert Hyatt     */
/*    Now uses pipec.h as entry point   */
/*    into the library.                 */
/*--------------------------------------*/
wdesc()
{
#include <malloc.h>
#ifdef _MSDOS
#include <stdlib.h>
#else
#include <unistd.h>
#endif
#include "pipec.h"

  int i,j,ret;
  char buffer[DESCWIDTH+1];

  extern int Ndesc;
  extern int Descriptors_written;
  extern int Recl;
/************************ New Variables ****************************/
  extern char         *Rbuffer;
  extern char          Sbuffer[];
  extern BUFFER_HEAD  _Rbuffer;
  extern int           Next_start;

  char   *mktemp();
/********************* End New Variables ***************************/


  if (Descriptors_written) return (-1);  /* Can't write them twice!! */
  ret=0;
  for(i=0;i<Ndesc;i++)				/* Contruct descriptor */
  {
    if(!checkflag(OUTPUT,i)) continue; 		/* If not to output, ignore */
    condesc(buffer,i);
    j=pwrite(dataout,buffer,DESCWIDTH);		/* Send out pipe */
    if(j<1) {ret=(-1); break;}
    ret+=j;
  }

/*********************** New Stuff ********************************/
  _Rbuffer.recl              =  Next_start;
  _Rbuffer.nrecs             =  0;
  _Rbuffer.nbufs             =  0;
  _Rbuffer.num_fixed         =  FALSE;
  if ((_Rbuffer.working =  (RECPTR *) malloc(sizeof(RECPTR))) == NULL) return(FALSE);
  if ((_Rbuffer.working->data  =  malloc(_Rbuffer.recl))      == NULL) return(FALSE);
  if ((_Rbuffer.end =      (RECPTR *) malloc(sizeof(RECPTR))) == NULL) return(FALSE);
  _Rbuffer.end->next         =  _Rbuffer.end;
  _Rbuffer.first             =  _Rbuffer.end;
  _Rbuffer.last              =  _Rbuffer.end;
  _Rbuffer.current           =  _Rbuffer.end;
  _Rbuffer.num_current       =  BufNoValue;
  _Rbuffer.last_request      =  _Rbuffer.end;
  _Rbuffer.num_last_req      =  BufNoValue;
  _Rbuffer.lastVMrec         =  _Rbuffer.end;
  _Rbuffer.num_lastVMrec     =  BufNoValue;

  if ((_Rbuffer.vmfilename   =  fopen(mktemp("/var/tmp/vmf.XXXXXX"), "w+")) == NULL) return(FALSE);
#ifndef PAGESIZE
#define PAGESIZE 4000
#endif
  _Rbuffer.pagesize          =  PAGESIZE;  /* (sysconf(_SC_PAGESIZE)) */
  _Rbuffer.recs_per_page     =  (_Rbuffer.pagesize/ _Rbuffer.recl);
  _Rbuffer.num_outpage       =  0;
  _Rbuffer.num_in_outpage    =  0;
  _Rbuffer.num_inpage1       =  BufNoValue;
  _Rbuffer.num_inpage2       =  BufNoValue;
  _Rbuffer.data_space_used   =  0;
                                     
  if ((_Rbuffer.outpage     = malloc(_Rbuffer.pagesize)) == NULL) return(FALSE);
  if ((_Rbuffer.inpage1     = malloc(_Rbuffer.pagesize)) == NULL) return(FALSE);
  if ((_Rbuffer.inpage2     = malloc(_Rbuffer.pagesize)) == NULL) return(FALSE);
  if ((_Rbuffer.inpage1_bak = malloc(_Rbuffer.pagesize)) == NULL) return(FALSE);
  if ((_Rbuffer.inpage2_bak = malloc(_Rbuffer.pagesize)) == NULL) return(FALSE);
  
  Rbuffer                  =  _Rbuffer.working->data;
/********************* End New Stuff ******************************/

  descend();
  return(ret);
}
