/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)buffrec.c	1.2  (UCLA, IGPP) 20 Apr 1994 
 */

/* -- BUFFREC ---------------------------------------------- */
/* Writes Buffsize records to the disk buffer.               */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/* 	NONE                                                 */
/*                                                           */
/* RETURN VALUES:                                            */
/* 	Returns the number of records read or -1 for         */
/*      an error.                                            */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  8/30/86 - Marco Zagha                */
/*                  Under GG44 support.                      */
/*               Edited:04/14/94 - Gilbert Hyatt             */
/*                 Now uses pipec.h as entry point into the  */
/*                 library.                                  */  
/* --------------------------------------------------------- */
buffrec()
{
#include "pipec.h"
 
  extern int Buffstarted;
  extern int Buffsize;
  extern int Inbuff;
  extern int Currentrec;

  if (!Buffstarted) return (-1);

  for (Inbuff = 0; Inbuff < Buffsize; Inbuff++)
    {
      if (setrecord(Inbuff+1) < 0) return (Inbuff); /* adjust to 1-indexing */
      if (rdata() <= 0) return (Inbuff);
      if (wbuff() <= 0) return (Inbuff);
    }
  return (Inbuff);
}

