/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)condesc.c	1.3  (UCLA, IGPP) 20 Apr 1994 
 */
/*-- CONDESC ----------------------------*/
/* contructs a descriptor record from    */
/* the descriptor database for the given */
/* column number.                        */
/*                                       */
/* Development History:                  */
/*     Begun: 2/86 - Todd King           */
/*       Under GH06 support.             */
/*  Edited:04/14/94 - Gilbert Hyatt      */
/*    Now uses pipec.h as entry point    */
/*    into the library.                  */
/*---------------------------------------*/
condesc(string,descno)
int descno;
char string[];
{
#include "pipec.h"

   int j;
   char temp[4];

   extern DESC Desc[];

   if(descno> MAXCOLS) return(-1);   /* No can do */
   for(j=0;j<32;j++) string[j]=Desc[descno].longcol[j];
   for(j=0;j<32;j++) {string[j]=Desc[descno].longcol[j];}
   for(j=0;j<8;j++) {string[32+j]=Desc[descno].shortcol[j];}
   for(j=0;j<16;j++) {string[40+j]=Desc[descno].units[j];}
   string[56]=Desc[descno].type;
   sprintf(temp,"%3d",Desc[descno].width);
   for(j=0;j<3;j++) {string[57+j]=temp[j];}
   sprintf(temp,"%2d",Desc[descno].sort);
   for(j=0;j<2;j++) {string[60+j]=temp[j];}
   string[62]='\0'; 
   return(0);
}

