/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)getcolstr.c	1.6  (UCLA, IGPP) 20 Apr 1994 
 */
/*-- GETCOLSTR --------------------------*/
/* Gets the string associated with the   */
/* requested column. If the column is    */
/* not Alphanumeric a null string is     */
/* returned.                             */
/*                                       */
/* Entry requirements:                   */
/*   COLNAME: The short column name      */
/*            of the column to get its   */
/*            corresponding string value */
/*                                       */
/* Developement History:                 */
/*    Begun:  2/21/86 - Todd King        */
/*             Under GH06 support.       */
/*    Edited: 05/12/93 -Gilbert Hyatt    */
/*             Now outputs string for all*/
/*             column tyeps              */
/*  Edited:04/14/94 - Gilbert Hyatt      */
/*    Now uses pipec.h as entry point    */
/*    into the library.                  */
/*---------------------------------------*/
char *getcolstr(colname)
char colname[];
{
#include "pipec.h"
#include "timec.h"

  int   cnum;
  char  *ptr;

  extern char Sbuffer[], *Rbuffer;
  extern DESC Desc[];
  extern int  DefTimeStyle;

  Sbuffer[0]='\0';
  cnum=colnum(colname);
  cnum--;
  if(cnum < 0) return(Sbuffer); 		/* Not found */

  ptr = (Rbuffer + Desc[cnum].start);
  switch(Desc[cnum].type) {
    case 'I':
      sprintf(Sbuffer, "%d", (* (int *)ptr));
      break;
    case 'R':
      sprintf(Sbuffer, "%f", (* (float *)ptr));
      break;
    case 'D':
      sprintf(Sbuffer, "%lf", (* (double *)ptr));
      break;
    case 'A':
      strncpy(Sbuffer, ptr, Desc[cnum].width);
      Sbuffer[Desc[cnum].width] = '\0';
      break;
    case 'T':
      if (DefTimeStyle < 0) {
	strcpy(Sbuffer, make_time_str((* (double*)ptr), DFS_STYLE));
      } else {
	strcpy(Sbuffer, make_time_str((* (double*)ptr), DefTimeStyle));
      }
      break;
  }
  return(Sbuffer);
}


