/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)rdesc.c	1.3  (UCLA, IGPP) 20 Apr 1994 
 */
/*-- RDESC ----------------------------------*/
/* Reads the descriptor pipe and fills an    */
/* internal database (structure array) with  */
/* the information.                          */
/*                                           */
/* Entry Requirements:                       */
/*    NONE                                   */
/*                                           */
/* Developement History:                     */
/*   Begun: 2/21/86 - Todd King              */
/*            Under GH06 support.            */
/*   Update: 3/3/87 - Marco Zagha            */
/*               EODESC added                */
/*            Under GG44 support.            */
/*   Update: 6/8/87 - Marco Zagha            */
/*              (No descriptor pipe).        */
/*            Under GG44 support.            */
/*   Edited:04/14/94 - Gilbert Hyatt         */
/*     Now uses pipec.h as entry point       */
/*     into the library.                     */
/*-------------------------------------------*/
int
rdesc()
{
#include "pipec.h"

  int i,j,sum;
  char temp[4];
  char buffer[DESCWIDTH];

  extern DESC Desc[];
  extern int Ndesc,Recl,Next_start;

  i=0;					/* Preset */
  sum=0;
  while((pread(datain,buffer,DESCWIDTH) > 0) && (i<MAXCOLS))
  {
    if (strncmp(buffer, EODESC, DESCWIDTH) == 0) break;
    Desc[i].flags=0|INPUT|OUTPUT;			/* Set flags */
    for(j=0;j<32;j++) {Desc[i].longcol[j]=buffer[j];}   /* Long col name */
    Desc[i].longcol[j]='\0';			        /* Terminate string */
    for(j=0;j<8;j++) {Desc[i].shortcol[j]=buffer[32+j];}/* Short col name */
    Desc[i].shortcol[j]='\0';				/* Terminate string */
    for(j=0;j<16;j++) {Desc[i].units[j]=buffer[40+j];}  /* Units */
    Desc[i].units[j]='\0'; 				/* Terminate string */
    Desc[i].type=buffer[56];				/* Variable type */
    for(j=0;j<3;j++) {temp[j]=buffer[57+j];} 		/* Store width string */
    temp[j]='\0';					/* Terminate */
    Desc[i].width=atoi(temp);				/* Convert */
    for(j=0;j<2;j++) {temp[j]=buffer[60+j];}            /* Sort order */
    temp[j]='\0';					/* Terminate */
    Desc[i].sort=atoi(temp); 				/* Convert */
    Desc[i].start=sum;					/* Save index */
    sum+=Desc[i].width;					/* Incriment index */
    i++;						/* Incriment count */
  }
  Ndesc=i;						/* Save count */
  Recl=sum;						/* Save recl */
  Next_start=sum;					/* Next avail. byte */
  return(i);						/* Number of desc */
}

