/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)shiftbuff.c	1.2  (UCLA, IGPP) 20 Apr 1994 
 */

/* -- SHIFTBUFF -------------------------------------------- */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/* 	NRECS:  The number of records to shift the buffer.   */
/*                                                           */
/* RETURN VALUES:                                            */
/* 	The number of records shifted or -1 for an error.    */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  9/2/86 - Marco Zagha                 */
/*                  Under GG44 support.                      */
/* --------------------------------------------------------- */
shiftbuff(nrecs)
int	nrecs;
{
  extern int Buffstarted;
  extern int Buffsize;
  extern int Buffdesc;
  extern int Inbuff;
  extern int Rotateindex;

  int j;
  unsigned int done = 0;
  int retval = 0;

  if (!Buffstarted) return (-1);

  for (j = 1; j <= nrecs; j++)
    {
      setrecord(j);
      if (rbuff() <= 0) return (-1);
      if (wdata() <= 0) return (-1);
    }

  for (j = 1; (j <= nrecs) && (!done); j++)
    {
      if (rdata() > 0)
	{
	  retval++;
	  setrecord(j);
	  if (wbuff() <= 0) return (-1);
	}
      else done = 1;
    }
  /* Adjust the start of the rotating buffer.  The -1 and +1 are
   * for proper mod arithmetic with 1-indexing.
   */
  Rotateindex = ((Rotateindex - 1 + nrecs) % Buffsize) + 1;
  Inbuff = Inbuff - nrecs + retval;  /* subtract records written and
					add records read */
  return (retval);
}

