/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)helpc.c	1.1   (UCLA/IGPP)   11 Dec 1992
 */
#include <stdio.h>
#include "helpc.h"
#include "sysmax.h"
#include "filetype.h"
/*-- HELP ---------------------------------------------------------*/
/* Attempts to list the help associated with a keyword. Searches   */
/* a list of paths for the help library then tries to extract      */
/* the text associated with the keyword.                           */
/*                                                                 */
/* NOTE: If the more filter is unable to be started help is listed */
/*       to 'stdout'                                               */
/*                                                                 */
/* Returns:                                                        */
/*   -3: if the help library exists, but you have no access rights */
/*       to it.                                                    */
/*   -2: If no help is associated with the keyword in any of the   */
/*       libararies found                                          */
/*   -1: If the help library can't be found.                       */
/*    0: All went well                                             */
/*                                                                 */
/*  Entry Requirements:                                            */
/*    KEYWORD: The keyword of the help entry                       */
/*    LIBNAME: The name of the library the help should be in       */
/*    PATHLIST: The list of paths to search for the library.       */
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 04/12/87 - Todd King                                  */
/*                   Under GG44 support                            */
/*-----------------------------------------------------------------*/
int	start_more();

help(keyword, libname, pathlist)
char keyword[];
char libname[];
char *pathlist[];
{
  struct lib_entry *libentry();

  char *ctime();
  long atol();

  struct lib_entry *l_entry;
  char fullpath[MAXPATH];
  FILE *fptr, *outhelp;
  int i, c;
  long time;

/* Local error numbers */

  int no_access	= -3;
  int no_help	= -2;
  int no_lib	= -1;
  int ok	=  0;

  switch(findfile(libname, pathlist, fullpath, TEXTFILE))
  {
    case NOREAD:
    case NOACCESS:
      return(no_access);
    case TEXTFILE:
      break;
    default:
      return(no_lib);
  }
  if((l_entry = libentry(fullpath, keyword)) == NULL) return(no_help);

  if((fptr = fopen(fullpath, "r")) == NULL) return(no_access);

  if(start_more(&outhelp) == 0) {outhelp = stdout;}
  time = atol(l_entry->le_date);
  fprintf(outhelp, "Subject: %s    last changed: %s\n", keyword, 
    ctime(&time));
  fseek(fptr, l_entry->le_start, 0);
  for(i=0; i<l_entry->le_length; i++)
  {
    c = fgetc(fptr);
    fputc(c, outhelp);
  }
  fclose(fptr);
#ifndef _MSDOS
  pclose(outhelp);
#endif
  return(ok);
}


/*-- LIBENTRY -----------------------------------------------------*/
/* Searches a given library for an entry which matches a given     */
/* name. The library is one created by 'ar'.                       */
/*                                                                 */
/*                                                                 */
/* Returns:                                                        */
/*   NULL if the library can not be accesed, Otherwise, it returns */
/*   a pointer to a 'lib_entry' structure. This structure is       */
/*   re-used with each call. The structure is filled with all the  */
/*   information availbale.                                        */
/*                                                                 */
/*  Entry Requirements:                                            */
/*     FULLPATH: The full path to the library to search.           */
/*     KEYWORD: The 'name' of the entry to search for.             */
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 04/12/87 - Todd King                                  */
/*-----------------------------------------------------------------*/
#ifndef _MSDOS
#include <ar.h>
#endif
struct lib_entry *
libentry(fullpath, keyword)
char fullpath[];
char keyword[];
{     
#ifdef _MSDOS
  fprintf(stderr, "libentry() not functional.\n"); 
  return(NULL);
#else
  extern struct lib_entry entry_info;
  struct ar_hdr hdr;
  char ar_name[sizeof(hdr.ar_name)];
  char tmpstr[SARMAG];
  int fno;
  int hdr_size, flen, an_len;
  int filler;

  an_len = sizeof(hdr.ar_name);
  hdr_size = sizeof(struct ar_hdr);
  entry_info.le_start = 0;
  entry_info.le_length = 0;
  strcpy(entry_info.le_date, "");

  if((fno = fileno(fopen(fullpath, "r"))) == 0) return(NULL);

  read(fno, tmpstr, SARMAG);	/* read magic string */
  if(strncmp(tmpstr, ARMAG, SARMAG) != 0) /* Not really an archive file */
  {
    close(fno);
    return(NULL);
  }

  strcpy(ar_name, "");
  filler = SARMAG;
  while(strcmp(ar_name, keyword) != 0)
  {
    if(read(fno, (char *)(&hdr), hdr_size) != hdr_size) return(NULL);
    strncpy(ar_name, hdr.ar_name, an_len);
    ar_name[an_len] = '\0';
    trimspc(ar_name);
    entry_info.le_start += entry_info.le_length + hdr_size + filler;
    entry_info.le_length = atoi(hdr.ar_size);
    strncpy(entry_info.le_date, hdr.ar_date, LE_DATESIZE);
    entry_info.le_date[LE_DATESIZE] = '\0';
    if(((entry_info.le_start + entry_info.le_length)%2) != 0) /* not on even */
      { filler = 1; }
    else filler = 0;
    lseek(fno, (long)entry_info.le_length + filler, 1);
  }
  close(fno);
  return(&entry_info);
#endif
}
