/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- MOP2 ----------------------------------------*/
/* MOP2 - Mask Oriented Parser. Parses a line of  */
/* text according to the mask definition. The     */
/* mask has stars (*) placed where variables are. */
/* The parts of the text are copied into the      */
/* successive elements of a given array of string */
/* pointers. The original input mask is not       */
/* altered. the original input line is.           */
/* For example, a mask like: *(*) will extract    */
/* the string 'sin' and '22' from the line        */
/* 'sin(22)'.                                     */
/*                                                */
/*  Returns the number of parts found,            */
/*   (a number >= 0)                              */
/*                                                */
/* NOTE: This function differs from the 'mop'     */
/*       in these ways:                           */
/*         o  if some but not all of the parts    */
/*            are found, the number of parts      */
/*            found will be returned.             */
/*            In mop, -1 is returned if all parts */
/*            are not found.  Also, if no parts   */
/*            are found, 0 is returned in mop2    */
/*            instead of -1.                      */
/*         o  mop2 accepts ANY NUMBER of          */
/*            deliminator strings between each    */
/*            '*'.  For example, if the mask      */
/*            is "* * *", the line                */
/*            "hello  there  fred" will be        */
/*            parsed into "hello", "there",       */
/*            and "fred", even though there are   */
/*            two spaces between each word.       */
/*                                                */
/*  Entry Requirements:                           */
/*    line: the line to parse.                    */
/*    mask: the mask to apply to the line.        */
/*    part: array of character pointers to place  */
/*          copies of the varaible portions of    */
/*          the line in.                          */
/*                                                */
/*  Development History:                          */
/*    Begun: 9/25/87 - Marco Zagha                */
/*      (from Todd King's mop function)           */
/*        Under GG44 support.                     */
/*    Update: 10/16/87 - Marco Zagha              */
/*      (acceptance of multiple deliminators)     */
/*        Under GY49 support.                     */
/*                                                */
/*  Version:                                      */
/*     @(#)mop2.c	1.1      (UCLA/IGPP)     03 Mar 1992               */
/*------------------------------------------------*/
#include <string.h>
int parse();
int findstr();

mop2(line, mask, part)
char *line, *mask, *part[];
{
  char tempstr[1024];
  char *mpart[256];
  int i, cnt, np, at;
  char *endofline;
  char *sptr;

  if(strlen(mask) == 0) return(0);
  strncpy(tempstr, mask, 1024);
  np=parse(tempstr, mpart, "*", 256);
  sptr = (&line[0]);
  endofline = sptr + strlen(line);
  cnt=0;
  for(i = 0; i < np; i++)
  {
    if(strlen(mpart[i]) == 0) continue;	/* No preceeding text required */
    at = findstr(mpart[i], sptr, '"');
    if(at < 0 ) 
    {
      if (i == 0 && strlen(mpart[i]) != 0)
	return(cnt);
      else
      {
	part[cnt] = sptr;
	return(++cnt);
      }
    }
    if(i == 0 && strlen(mpart[i]) != 0)   /* No preceeding variable */
    {
      if(at == 0)
      {
	sptr = sptr + at + strlen(mpart[i]);
        while (strncmp(sptr, mpart[i], strlen(mpart[i])) == 0)
          sptr += strlen(mpart[i]);
	continue;
      }
      else return(cnt);
    }
    part[cnt] = sptr;
    sptr[at] = '\0';
    sptr = sptr + at + strlen(mpart[i]);
    while (strncmp(sptr, mpart[i], strlen(mpart[i])) == 0)
      sptr += strlen(mpart[i]);
    cnt++;
    if(sptr > endofline) return(cnt);
  }
  if(strlen(mpart[np-1]) == 0) 		/* Handle variable at end of line */
  {
    part[cnt] = sptr;
    cnt++;
  }
  return(cnt);
}

