/*---------------------------------------------------------------*/
/*   Copyright (c) 1993 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)FittingName.c	1.2   (UCLA/IGPP)   20 Apr 1994
 */

#ifdef _MSDOS  
#include <stdio.h>
#define MAXPATHLEN	FILENAME_MAX
#else
#include <sys/param.h>	/* For MAXPATHLEN */
#endif

char xxFittingName[MAXPATHLEN + 1];

/*------------------------------------------------
  Sets a global variable with the value of the 
  fitting name.

  Entry Requirements:
      name : The name of the fitting.

  Developement History:
    Begun: 04/30/93  - Todd King
---------------------------------------------------*/
setFittingName(name)
char name[];
{
   strncpy(xxFittingName, name, MAXPATHLEN);
   xxFittingName[MAXPATHLEN] = '\0';	/* Proper termination */
   return(1);
}

/*------------------------------------------------
  Retrieves the global variable which contains 
  the value of the fitting name.

  Entry Requirements:
      NONE

  Developement History:
    Begun: 04/30/93  - Todd King
---------------------------------------------------*/
char *
getFittingName()
{
   return(xxFittingName);
}
