/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)flagset.c	1.3  (UCLA, IGPP) 20 Apr 1994 
 */
/*-- FLAGSET ---------------------------------*/
/* Sets the given flag on for the given       */
/* column in the descriptor structures.       */
/* Always returns 1.                          */
/*                                            */
/* Entry requirements:                        */
/*   FLAG: Flag or composite flag to set.     */
/*   COL:  Index of column descriptor to      */
/*         change.                            */
/*                                            */
/* NOTE:  the column index passed to flagset  */
/*        should use zero-indexing.           */
/*                                            */
/* Development History                        */
/*   Begun: 8/10/86 - Marco Zagha             */
/*            Under GG44 support.             */
/*  Edited:04/14/94 - Gilbert Hyatt           */
/*    Now uses pipec.h as entry point         */
/*    into the library.                       */
/*--------------------------------------------*/
#include "pipec.h"

flagset(flag, col)
unsigned int flag;
int col;
{
   extern DESC Desc[];

  /* bitwise OR Desc[col].flags with flag */

   Desc[col].flags |= flag;
   return (1);
}
