/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)make_buff.c	1.3  (UCLA, IGPP) 20 Apr 1994
*/
#include "pipec.h"

extern int Recl;	/* THe DFS record length of the data flow */

/*-- dfs_make_buffer -----------------------------------------------------
   Creates an area of memory ot hold a specific number of
   records. The length of a record is taken from the
   DFS environment variable 'Recl'. If it is unable to
   create the buffer a NULL pointer is returned, other a
   pointer to a structure DFS_RECBUFF is returned.

   Development History:
       Begun: 10/19/90 - Todd King
       Edited:04/14/94 - Gilbert Hyatt
         Now uses pipec.h as entry point into the library.
-------------------------------------------------------------*/
DFS_RECBUFF *
dfs_make_buffer(nrecs)
int nrecs;
{
   DFS_RECBUFF *recbuff;

   recbuff = (DFS_RECBUFF *)malloc(sizeof(DFS_RECBUFF));
   if(recbuff != NULL) {
      recbuff->raw = (char *)malloc(Recl * nrecs);
      if(recbuff->raw == NULL) {
         free(recbuff);
         recbuff = NULL;
      } else {
         recbuff->recl = Recl;   
         recbuff->max_recs = nrecs; 
         recbuff->nrecs = 0;
         recbuff->first_rec = 0;
         recbuff->cur_rec = 0;
      }  
   }
      
   return(recbuff);
}

