/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)setrec.c	1.2  (UCLA, IGPP) 20 Apr 1994 
 */

/* -- SETRECORD -------------------------------------------- */
/* Sets the record number in the buffer file to the record   */
/* specified by RECNUM.                                      */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*	RECNUM:  the record number to set the current record */
/*	         to in the buffer file.                      */
/*                                                           */
/* RETURN VALUES:                                            */
/*      1 for valid record number; -1 otherwise.             */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  8/30/86 - Marco Zagha                */  
/*                  Under GG44 support.                      */
/* --------------------------------------------------------- */
#include <stdio.h>
int
setrecord(recnum)
int	recnum;
{
  extern int Buffstarted;
  extern int Next_start;
  extern int Currentrec;
  extern int Buffdesc;
  extern int Inbuff;
  extern int Buffsize;
  extern int Rotateindex;
  extern FILE *Buffptr;
  
  int offset;

    if ((!Buffstarted) || (recnum < 1) || (recnum > Buffsize)) return (-1);

  /* Adjust to zero indexing and start of the rotating buffer */

  offset = ((recnum - 1) + (Rotateindex - 1)) % Buffsize;
  fseek(Buffptr, (long) (Next_start * offset), 0);
  Currentrec = recnum;
  return (1);
}

