/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      %W%  (UCLA, IGPP) %G% 
 */
/* -- UNIQNAME --------------------------------------------- */
/* Creates a unique column name based on a template.         */
/* Each time the function is called, an integer suffix is    */
/* appended to TEMPLATE, to create a unique name.            */
/* Example:  uniqname("TEST") returns "TEST", then "TEST1",  */
/*           then "TEST2", etc.                              */
/*                                                           */
/* ENTRY REQUIREMENTS:                                       */
/*	TEMPLATE:  A string which makes up the beginning of  */
/*	           the unique column name.                   */
/*                                                           */
/*                                                           */
/* Mapping for return values for char funtions               */
/*                                                           */
/* Function   Chars used      Return address                 */
/* --------   ----------      --------------                 */
/* scolname   0-8    9 chars      &Sbuffer[0]                */
/* lcolname   9-41  33 chars      &Sbuffer[9]                */
/* colunits   42-58 17 chars      &Sbuffer[42]               */
/* uniqname   59-67  9 chars      &Sbuffer[59]               */
/*                                                           */
/* RETURNS:                                                  */
/*	The column name created, or "" if a unique name      */
/*      could not be created.                                */
/*                                                           */
/*      Development History:                                 */
/*              Begun:  8/16/86 - Marco Zagha                */
/*                  Under GG44 support.                      */
/*              Update: 4/28/87 - Marco Zagha                */
/*                  Under GG44 support.                      */
/*              Edited:04/14/94 - Gilbert Hyatt              */
/*                Now uses pipec.h as entry point            */
/*                into the library.                          */
/* --------------------------------------------------------- */
char *uniqname(template)
char	template[];
{

#include <stdio.h>
#include <string.h>
#include "pipec.h"

  int	colnum();

  extern char Sbuffer[];

  char  *startptr;
  char	colname[9];
  char	tempstr[5];
  int	suffix;

  startptr = &Sbuffer[59];
  *startptr = '\0';

  /* if template doesn't exist, create it first */
  if (colnum(template) <= 0) return (template);

  for (suffix = 1; suffix <= MAXCOLS ; suffix++)
    {
      strcpy(colname, template);
      sprintf(tempstr, "%d", suffix);
      if((strlen(colname) + strlen(tempstr)) >= 8) {
	 colname[8 - strlen(tempstr)] = '\0';
      }
      strcat(colname, tempstr); /* strlen(colname) <= 8 */
      if (colnum(colname) <= 0)
	{
	  strcpy(startptr, colname);
	  return (startptr);
	}
    }

  /* Went through MAXCOLS attempts and couldn't make a unique
     column name ==> bad template */

  return (startptr);
}
