/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- KeywordMatch ------------------------------------------------
  Parses a string on the equal sign and searches the
  passed keyword list for a match to the first part 
  of the parsed string. If a match is found the index of
  the keyword is returned and "value" contains
  the portion of the string after the equal sign.
  The contents of "string" are not modified.

 Entry Requirements:
    string: The keyword=value string to parse.
    possible : The list of keywords to search.
    value : Filled with the value portion of "string".

 Return Values:
    index : The index of a matching keyword if the given 
	    word is a unique fraction of any keyword.
    -1    : If the word is not found (same as KeywordMatch()).
    -2    : If the word is ambiguous (same as KeywordMatch()).
    -3    : if the line is not in the form "keyword=value"
                                        
 Development History:                   
   Begun: 11/25/85 - Todd King          
          Under GH06 support.           
                                        
  Version:                              
     @(#)KWParse.c	1.2      (UCLA/IGPP)     15 Mar 1993
--------------------------------------------------------------------*/
#ifdef unix
#include <unistd.h>	/* For NULL */
#else
#include <stdio.h>	/* For NULL */
#endif                          
#include <string.h>	/* for strcpy() */ 
int parse();
int trimspc();
int scaseup();
int KeywordMatch();

KeywordParse(string, possible, value)
char string[];
char *possible[];
char value[];
{
   char *part[2];
   int	n;
 
   strcpy(value, string);
   n = parse(value, part, "=", 2);
   if(n < 2) return(-3);

   trimspc(part[0]);
   scaseup(part[0]);
   trimspc(part[1]);

   n = KeywordMatch(part[0], possible);
   if(n >= 0) { strcpy(part[0], part[1]); }
   return(n);
}
