
/*----------------------------------------------------------------
   Dumps a token list produced by pattern_parse().
   Useful for debugging purposes.

   Entry Requirements:
      pattern : A token list defining the pattern to compare
		the string to. Produced by pattern_parse().

   Return Value:
      none.
      
   Development History:
      Begun: 03/02/92 - Todd King

   Version:
      @(#)p_dump.c	1.1    (UCLA/IGPP)   03 Mar 1992
------------------------------------------------------------------*/
#include "pattern.h"
#include <stdio.h>	/* For printf() */

void
pattern_dump(pattern)
PATTERN *pattern;
{
   PATTERN *p;

   for(p = pattern; p != NULL; p = p->next) {
      switch(p->type) {
	 case PATTERN_TYPE_SINGLE_CHAR:
	    printf("Single Char\n");
	    break;
	 case PATTERN_TYPE_MULTIPLE_CHAR:
	    printf("Mulitple Char\n");
	    break;
	 case PATTERN_TYPE_FIXED:
	    printf("String: \"%s\"\n", p->text);
	    break;
	 default:
	    printf("Unknown type: %d\n", p->type);
	    break;
      }
   }
}

