/*---------------------------------------------------------------*/
/*   Copyright (c) 1992 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*-------------------------- ------------------------------------*/
/*
      @(#)BufUseRec.c	1.2  (UCLA, IGPP) 20 Apr 1994 
*/
/*---------------------------------------------------------------
  BufUseRec(int rec_num) -
    Make the rec_num record in the buffer list the active record.
 
  Return:
    FALSE: if rec_num is out of range on the number of records in
           list.
    TRUE:  eles.
        
  Entry Requirements:
    
 
  Development History:
    Began: 09/17/93 - Gilbert Hyatt.
    Edited:04/14/94 - Gilbert Hyatt 
      Now uses pipec.h as entry point into the library.
  ---------------------------------------------------------------*/
BufUseRec(rec_num)
int rec_num;
{
#include "pipec.h"


  extern BUFFER_HEAD  _Rbuffer;
  extern char         *Rbuffer;
  RECPTR              *ptr;
  int                 index;
 
  if (rec_num  < 0)                     return(FALSE);
  if (_Rbuffer.first == _Rbuffer.end)   return(FALSE);
  if (rec_num > _Rbuffer.nrecs)         return(FALSE);

  if (rec_num == 0) ptr = _Rbuffer.working;
  else              ptr = BufGetRecPtrOf(rec_num); 

   Rbuffer              = BufMapData(ptr);
  _Rbuffer.last_request = _Rbuffer.current;
  _Rbuffer.num_last_req = _Rbuffer.num_current;
  _Rbuffer.current      = ptr;
  _Rbuffer.num_current  = rec_num;
  
  return(TRUE);
}  /* end of BufUseRec() */

