/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)free_buff.c	1.3  (UCLA, IGPP) 20 Apr 1994
*/
#include "pipec.h"

/*-- dfs_free_buffer --------------------------------------------------
   Frees all memory allocated on behalf of the creation of a buffer.
   Once this call is made a buffer is no longer useable.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())

   Development History:
      Begun: 10/19/90 - Todd King
      Edited:04/14/94 - Gilbert Hyatt 
        Now uses pipec.h as entry point into the library.
 -----------------------------------------------------------------------*/
dfs_free_buffer(buffer)
DFS_RECBUFF *buffer;
{
   if(buffer == NULL) return(FALSE);

   free(buffer->raw);
   free(buffer);
}

