/*---------------------------------------------------------------*/
/*   Copyright (c) 1990 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)shift_buff.c	1.3  (UCLA, IGPP) 20 Apr 1994
*/
#include "pipec.h"

/*-- dfs_shift_buffer ---------------------------------------------
   Removes a specified number of records out of the record buffer.
   Records are removed from the top of the record buffer first.
   That is record 0 is removed first, record 1 is removed second and 
   so on. All remaining records are shifted so that the first
   remaining record is the first record in the buffer.
   If the number of records requested to move is
   greater than the maximum number in the buffer, then only the 
   maximum number in the buffer are shifted.

   Entry Requirements:
       buffer: A pointer to a record buffer (created by make_buffer())
       nrecs: The number of records to remove.
       write_out: A flag indicating whether or not to write the
	   shifted records out to the data flow. If TRUE the records
	   are written to the data flow, otherwise the records are not.

   Development History:
      Begun: 10/19/90 - Todd King
      Edited:04/14/94 - Gilbert Hyatt
        Now uses pipec.h as entry point into the library.
------------------------------------------------------------------*/
int
dfs_shift_buffer(buffer, nrecs, write_out)
DFS_RECBUFF *buffer;
int nrecs;
int write_out;
{
   int i;
   int shift;
   char *ptr;

   if(buffer == NULL) return(FALSE);
   if(nrecs == 0) return(TRUE);

   shift = nrecs;
   if(shift > buffer->nrecs) shift = buffer->nrecs;
   if(shift < 0) shift = 0;

   if(write_out) {
      for(i = 0; i < shift; i++) {
	 dfs_use_buffer_record(buffer, i);
	 wdata();
      }
   }

   buffer->nrecs -= shift;
   buffer->first_rec += shift;
   if(buffer->first_rec >= buffer->max_recs) {
      buffer->first_rec = buffer->first_rec - buffer->max_recs;
   }

   return(TRUE);
   
}

