/*
      @(#)sedr.h	1.1         (UCLA/IGPP)      7/20/94
*/


typedef struct {
#if defined(vax) || defined(_MSDOS)
  unsigned short file_id:5;
  unsigned short recs_per_block:5;
  unsigned short block_lenB:6;
  unsigned short block_lenA:5;
  unsigned short rec_length:11;
#else
  unsigned short rec_length:11;
  unsigned short block_lenA:5;
  unsigned short block_lenB:6;
  unsigned short recs_per_block:5;
  unsigned short file_id:5;
#endif
} LH_WORD;

typedef struct {
  LH_WORD lh_word;
  int4     num_recs;
  short   spare1;
  short   scid;
  int4     orbit;
  float   spare2;
} ATT_HDR;

typedef struct {
  short   year;
  short   doy;
  int4     msecs;
  float   lat;
  float   lon;
  float   spare;
} ATT_DATA;

typedef struct {
  LH_WORD lh_word;
  int4     num_recs;
  short   spare1;
  short   scid;
  int4     orbit;
  short   start_year;
  short   start_doy;
  int4     start_msec;
  short   stop_year;
  short   stop_doy;
  int4     stop_msec;
  int4     spare[276];
} EPHEM_HDR;



typedef struct {
  short    year;
  short    doy;
  int4      msecs;
  double   julian_date;                   /* 3 columns not written to output */ 
  double   gregorian_date;                /* Data types uncertain            */
  double   utc;                                               /* 00 */
  double   geo_range_rate_of_pvo;                             /* 01 */
  double   geo_velocity_of_pvo;                               /* 02 */
  double   geo_earth_pvo_range;                               /* 03 */
  double   helio_sun_pvo_range;                               /* 04 */
  double   helio_pvo_inertial_velocity;                       /* 05 */
  double   helio_pvo_inertial_path_angle;                     /* 06 */
  double   helio_cel_lat_pvo;                                 /* 07 */
  double   helio_cel_lon_pvo;                                 /* 08 */
  double   helio_cel_lat_earth;                               /* 09 */
  double   helio_cel_lon_earth;                               /* 10 */
  double   helio_x_pvo_ecliptic;                              /* 11 */
  double   helio_y_pvo_ecliptic;                              /* 12 */
  double   helio_z_pvo_ecliptic;                              /* 13 */
  double   helio_sun_pvo_range_ecliptic;                      /* 14 */
  double   helio_lon_pvo_ecliptic;                            /* 15 */
  double   geo_x_pvo_position;                                /* 16 */
  double   geo_y_pvo_position;                                /* 17 */
  double   geo_z_pvo_position;                                /* 18 */
  double   geo_x_pvo_velocity;                                /* 19 */
  double   geo_y_pvo_velocity;                                /* 20 */
  double   geo_z_pvo_velocity;                                /* 21 */
  double   helio_x_pvo_position;                              /* 22 */
  double   helio_y_pvo_position;                              /* 23 */
  double   helio_z_pvo_position;                              /* 24 */
  double   helio_x_pvo_velocity;                              /* 25 */
  double   helio_y_pvo_velocity;                              /* 26 */
  double   helio_z_pvo_velocity;                              /* 27 */
  double   venus_x_pvo_position;                              /* 28 */
  double   venus_y_pvo_position;                              /* 29 */
  double   venus_z_pvo_position;                              /* 30 */
  double   venus_x_pvo_velocity;                              /* 31 */
  double   venus_y_pvo_velocity;                              /* 32 */
  double   venus_z_pvo_velocity;                              /* 33 */
  double   venus_pvo_venus_range;                             /* 34 */
  double   venus_pvo_velocity;                                /* 35 */
  double   fixed_earth_pvo_lat;                               /* 36 */
  double   fixed_earth_pvo_lon;                               /* 37 */
  double   fixed_earth_pvo_velocity;                          /* 38 */
  double   fixed_earth_pvo_path_angle;                        /* 39 */
  double   fixed_earth_pvo_azimuth_angle;                     /* 40 */
  double   fixed_venus_pvo_lat;                               /* 41 */
  double   fixed_venus_pvo_lon;                               /* 42 */
  double   fixed_venus_pvo_velocity;                          /* 43 */
  double   fixed_venus_pvo_path_angle;                        /* 44 */
  double   fixed_venus_pvo_azimuth_angle;                     /* 45 */
  double   earth_pvo_venus_angle;                             /* 46 */
  double   earth_pvo_sun_angle;                               /* 47 */
  double   sun_earth_pvo_angle;                               /* 48 */
  double   earth_sun_pvo_angle;                               /* 49 */
  double   sun_pvo_venus_angle;                               /* 50 */
  double   venus_earth_pvo_angle;                             /* 51 */
  double   periapsis_flag;                                    /* 52 */
  double   x_coord_of_x_axis;                                 /* 53 */
  double   y_coord_of_x_axis;                                 /* 54 */
  double   z_coord_of_x_axis;                                 /* 55 */
  double   x_coord_of_y_axis;                                 /* 56 */
  double   y_coord_of_y_axis;                                 /* 57 */
  double   z_coord_of_y_axis;                                 /* 58 */
  double   x_coord_of_z_axis;                                 /* 59 */
  double   y_coord_of_z_axis;                                 /* 60 */
  double   z_coord_of_z_axis;                                 /* 61 */
  double   nadir_roll;                                        /* 62 */
  double   nadir_look;                                        /* 63 */
  double   ram_roll;                                          /* 64 */
  double   ram_look;                                          /* 65 */
  double   spare1[8];                                         /* 66,67,68,69,70,71,72,73 */
  double   venus_cel_lat_pvo;                                 /* 74 */
  double   venus_cel_lon_pvo;                                 /* 75 */
  double   venus_pvo_path_angle;                              /* 76 */
  double   venus_pvo_azimuth_angle;                           /* 77 */
  double   venus_pvo_range;                                   /* 78 */
  double   venus_x_earth_position;                            /* 79 */
  double   venus_y_earth_position;                            /* 80 */
  double   venus_z_earth_position;                            /* 81 */
  double   venus_x_earth_velocity;                            /* 82 */
  double   venus_y_earth_velocity;                            /* 83 */
  double   venus_z_earth_velocity;                            /* 84 */
  double   venus_earth_venus_range;                           /* 85 */
  double   venus_cel_lat_of_earth_dir;                        /* 86 */
  double   venus_cel_lon_of_earth_dir;                        /* 87 */
  double   venus_x_sun_position;                              /* 88 */
  double   venus_y_sun_position;                              /* 89 */
  double   venus_z_sun_position;                              /* 90 */
  double   venus_x_sun_velocity;                              /* 91 */
  double   venus_y_sun_velocity;                              /* 92 */
  double   venus_z_sun_velocity;                              /* 93 */
  double   venus_sun_venus_range;                             /* 94 */
  double   venus_cel_lat_of_sun_dir;                          /* 95 */
  double   venus_cel_lon_of_sun_dir;                          /* 96 */
  double   venus_orbit_semi_major_axis;                       /* 97 */
  double   venus_orbit_eccentricity;                          /* 98 */
  double   venus_time_from_periapsis;                         /* 99 */
  double   venus_radius_of_closest_approach;                  /*100 */
  double   venus_orbit_period;                                /*101 */
  double   venus_spacecraft_true_anomaly;                     /*102 */
  double   venus_orbit_inclination;                           /*103 */
  double   venus_lon_of_ascending_node;                       /*104 */
  double   venus_argument_of_periapsis;                       /*105 */
  double   venus_x_of_unit_vector_to_periapsis;               /*106 */
  double   venus_y_of_unit_vector_to_periapsis;               /*107 */
  double   venus_z_of_unit_vector_to_periapsis;               /*108 */
  double   venus_x_of_unit_normal_to_orbital_plane;           /*109 */
  double   venus_y_of_unit_normal_to_orbital_plane;           /*110 */
  double   venus_z_of_unit_normal_to_orbital_plane;           /*111 */
  double   sun_venus_pvo_angle;                               /*112 */
  double   sun_earth_venus_angle;                             /*113 */
  double   venus_x_pvo_position2;                             /*114 */
  double   venus_y_pvo_position2;                             /*115 */
  double   venus_z_pvo_position2;                             /*116 */
  double   venus_x_pvo_velocity2;                             /*117 */
  double   venus_y_pvo_velocity2;                             /*118 */
  double   venus_z_pvo_velocity2;                             /*119 */
  double   venus_mean_equinox_x_earth_position;               /*120 */
  double   venus_mean_equinox_y_earth_position;               /*121 */
  double   venus_mean_equinox_z_earth_position;               /*122 */
  double   venus_mean_equinox_x_sun_position;                 /*123 */
  double   venus_mean_equinox_y_sun_position;                 /*124 */
  double   venus_mean_equinox_z_sun_position;                 /*125 */
  double   venus_mean_equinox_x_pvo_position;                 /*126 */
  double   venus_mean_equinox_y_pvo_position;                 /*127 */
  double   venus_mean_equinox_z_pvo_position;                 /*128 */
  double   venus_mean_equinox_x_pvo_velocity;                 /*129 */
  double   venus_mean_equinox_y_pvo_velocity;                 /*130 */
  double   venus_mean_equinox_z_pvo_velocity;                 /*131 */
  double   cel_lat_of_earth_to_pvo_direction;                 /*132 */
  double   cel_lon_of_earth_to_pvo_direction;                 /*133 */
  double   spare2[5];                                         /* 134,135,136,137,138 */ 
} EPHEM_DATA;          
                


typedef struct {
  short    t1;
  short    t2;
  int4      t3;
  double   julian_date;
  int4	   gregorian_dateA;
  int4	   gregorian_dateB;
  double   e_array[139];
} EPHEM_ARRAY;


typedef union {
  EPHEM_ARRAY ephem_array;
  EPHEM_DATA  e_data;
} EPHEM_UNION;


typedef struct {
  LH_WORD    lh_word;
  int4        spare[5];
} SL_HDR;

typedef struct {
  char       hdr_line[24];
} SL_DATA;

typedef struct {
  LH_WORD    lh_word;
  int4       num_recs;
  short      spare1;
  short      scid;
  int4        orbit;
  short      start_year;
  short      start_doy;
  int4	     start_msec;
  short      stop_year;
  short      stop_doy;
  int4	     stop_msec;
  int4        spare2[4];
} PULSE_HDR;

typedef struct{
#if defined(vax) || defined(_MSDOS)
  unsigned_int4 spare4:8;      /* bits 25-32 */
  unsigned_int4 fire:2;        /* bits 23-24 */
  unsigned_int4 spare3:2;      /* bits 21-22 */
  unsigned_int4 srrm:2;        /* bits 19-20 */
  unsigned_int4 spare2:2;      /* bits 17-18 */
  unsigned_int4 clck:2;        /* bits 15-16 */
  unsigned_int4 spare1:12;     /* bits 3-14  */
  unsigned_int4 strm:2;        /* bits 1-2   */
#else
  unsigned_int4 strm:2;        /* bits 1-2   */
  unsigned_int4 spare1:12;     /* bits 3-14  */
  unsigned_int4 clck:2;        /* bits 15-16 */
  unsigned_int4 spare2:2;      /* bits 17-18 */
  unsigned_int4 srrm:2;        /* bits 19-20 */
  unsigned_int4 spare3:2;      /* bits 21-22 */
  unsigned_int4 fire:2;        /* bits 23-24 */
  unsigned_int4 spare4:8;      /* bits 25-32 */
#endif
} PT_WORD;

typedef struct {
  short      year_of_Fs;
  short      doy_of_Fs;
  int4	     msec_of_Fs;
  short      year_of_rip;
  short      doy_of_rip;
  int4	     msec_of_rip;
  short      year_of_ram;
  short      doy_of_ram;
  int4	     msec_of_ram;
  short      year_of_nadir;
  short      doy_of_nadir;
  int4	     msec_of_nadir;
  double     msec_since_last_real_sun_pulse; /*Not output, Data type uncertain*/
  PT_WORD    pt_word;
  int4        spare3;
} PULSE_DATA;

typedef struct {
  LH_WORD    lh_word;
  int4        num_recs;
  short      spare1;
  short      scid;
  int4        orbit;
  short      start_year;
  short      start_doy;
  int4        start_msec;
  short      stop_year;
  short      stop_doy;
  int4        stop_msec;
  int4        spare2[2];
} ROLL_HDR;

  
typedef struct {
  short      year;
  short      doy;
  int4	     msecs;
  int4        spare1[2];
  float      cel_lat_of_pulse_star;
  float      cel_lon_of_pulse_star;
  float      error_in_simulated_srr;
  int4        spare2[3];
} ROLL_DATA;

typedef struct {
  LH_WORD    lh_word;
  int4        num_recs;
  short      spare1;
  short      scid;
  int4       orbit;
  short      start_year;
  short      start_doy;
  int4	     start_msec;
  short      stop_year;
  short      stop_doy;
  int4	     stop_msec;
  int4        spare2[2];
} SPIN_HDR;

typedef struct {
  short      year;
  short      doy;
  int4	     msecs;
  float      spin_period;
  float      time_delay;
  int4        spare[6];
} SPIN_DATA;
 


 
char *hdr_lines[] = {
"Description                                                   Name   col#",
"+========================================================================",
""
};

char *desc_lines[] = {
"| Time column is automatically added to all data files!       | ",
"|                                                             | ",
"|                                                             | ",
"|                                                             | ",
"|ET - UTC, set (Universal Time Co-ordinated)                  |ETMUTC   4",
"|Range rate of probe. km/sec                        +         |RANGRF   5",
"|Magnitude of velocity vector km/sec (speed of S/C) |Geocentrc|MAGVEL   6",
"|Earth.probe range, km (radius to S/C)              +         |REARPR   7",
"|Range to probe, km                                 +         |MRANGE   8",
"|Probe inertia velocity, km/sec                     |         |MMAGVF   9",
"|Probe inertial path angle, deg                     |         |HINFTP  10",
"|Celestial latitude of probe, deg                   |HELIO-   |CELLTF  11",
"|Celestial longitude of probe, deg                  |CENTRIC  |CELLNF  12",
"|Celestial latitude of Earth, deg                   |         |CELLTE  13",
"|Celestial longitude of Earth, deg                  |         |CELLNE  14 ",
"|X component of S/C in Sun-Earth line, km           |HELIO-   |XSCSEL  15",
"|Y component of S/C in Sun.Earth line, km           |CENTRIC  |YSCSEL  16",
"|Z component of S/C in Sun.Earth line, km           |         |ZSCSEL  17",
"|Sun-probe distance in Sun-Earth X-Y plane, km      |         |SPSE    18", 
"|Longitude of S/C in Sun-Earth line system, deg     +         |LNPSEL  19",
"|X component of geocentric r of S/C, km      +                |XPGSFF  20",
"|Y component of geocentric r of S/C, km      |                |YPGSFF  21",
"|Z component of geocentric r of S/C, km      | Space-fixed    |ZPGSFF  22",
"|X component of geocentric r of S/C, km/sec  | Coordinates    |DXPGSF  23",
"|Y component of geocentric r of S/C, km/sec  | FERP           |DYPGSF  24",
"|Z component of geocentric r of S/C, km/sec  | Earth Mean     |DZPGSF  25",
"|X component of heliocentric r of S/C, km    | Equinox &      |XPHSFF  26",
"|Y component of heliocentric r of S/C, km    | Ecliptic of    |YPHSFF  27",
"|Z component of heliocentric r of S/C, km    | 1950.0         |ZPHSFF  28",
"|X component of heliocentric r of S/C, km/sec|                |DXPHSF  29",
"|Y component of heliotentric r of S/C, km/sec|                |DYPHSF  30",
"|Z component of heliocentric r of S/C, km/sec|                |DZPHSF  31",
"|X component of body 1 - S/C r, km           |+               |XP1SFF  32",
"|Y component of body 1 - S/C r, km           ||               |YP1SFF  33",
"|Z component of body 1 - S/C r, km           ||               |ZP1SFF  34",
"|X component of body 1 - S/C r, km/sec       || Body 1 =      |DXP1SF  35",
"|Y component of body 1 - S/C r, km/sec       || Venus         |DYP1SF  36",
"|Z component of body 1 - S/C r, km/sec       ||               |DZP1SF  37",
"|Body 1 - S/C range, km                      ||               |B1MAGR  38",
"|Body l - S/C velocity magnitude, km/sec     ++               |B1MAGV  39",
"|Latitude of probe, deg                      +                |EALATP  40",
"|Longitude of probe, deg                     |                |EALOMP  41",
"|Speed of probe relative to body  <km/s>     | Body-Fixed     |EAVELP  42",
"|Body fixed path angle of probe. deg         | Earth          |EAPTHP  43",
"|Body fixed azmuth angle of probe. deg       +                |EAAZIP  44",
"|Latitude of probe. deg                     +                 |B1LATP  45",
"|Longitude of probe. deg                    |                 |B1LOMP  46 ",
"|Speed of probe relative to body <km/s>     |Body 1 = Venus   |B1VELP  47",
"|Body fixed path angle of probe. deg        |                 |B1PTHP  48",
"|Body fixed azimuth angle of probe. deg     +                 |B1AZIP  49",
"|Earth-probe-body 1 angle, deg             +                  |EPB1AN  50",
"|Earth-probe-sun angle, deg                | Angle Group      |EPSUAN  51",
"|Sun-Earth-probe angle, deg                | All angles in    |SEPANG  52",
"|Earth-Sun-probe angle, deg                | degrees          |ESPANG  53",
"|Sun-probe-body 1 angle, deg               |                  |SPB1AN  54",
"|Body 1-Earth-probe angle, deg             +                  |B1EPAN  55",
"|Flag for periapsis (See EN/3)                                |PERIAP  56",
"|      X-coordinate of XROLL   +            +                 |XROLLX  57",
"|      Y-coordinate of XROLL   |            |                 |XROLLY  58",
"|      Z-coordinate of XROLL   |            |                 |XROLLZ  59",
"|      X-coordinate of YROLL   |Attitude    |Spacecraft       |YROLLX  60",
"|      Y-coordinate of YROLL   | Data       |Centered         |YROLLY  61",
"|      Z-coordinate of YROLL   |            |Non-Rotating     |YROLLZ  62",
"|      X-coordinate of ATT     |            |Coordinates      |ATTX    63",
"|      Y-coordinate of ATT     |            |                 |ATTY    64",
"|      Z-coordinate of ATT     +            |                 |ATTZ    65",
"| NADROL                                    |                 |NADROL  66",
"| NADLOK                                    |                 |NADLOK  67",
"| RAMROL                                    |                 |RAMROL  68",
"| RAMLOK                                    +                 |RAMLOK  69",
"|                                                             |        70",
"|                                                             |        71",
"| 70-77 are filled with spares                                |spares  72",
"|                                                             |        73",
"|                                                             |        74",
"|                                                             |        75",
"|                                                             |        76",
"|                                                             |        77",
"|Celestial latitude of probe, deg           +                 | DECPI  78",
"|Celestial longitude of probe, deg          |                 | RAP1   79",
"|Flight-path angle of probe, deg            |                 | PTHP1  80",
"|Azimuth angle of probe, deg                |                 | AZP1   81",
"|Range rate of probe. km/sec                |                 | DR1    82",
"|X-component of Earth position, km          |        (EC)     | XE1    83",
"|Y-component of Earth position, km          |        (EC)     | YE1    84",
"|Z-component of Earth position, km          |        (EC)     | ZE1    85",
"|X-component of Earth velocity, km/sec      |        (EC)     | DXE1   86",
"|Y-component of Earth velocity, km/sec      |        (EC)     | DYE1   87",
"|Z-component of Earth velocity, km/sec      |        (EC)     | DZE1   88",
"|Venus-to-Earth range, km                   | Venus Centered  | RE1    89",
"|Celestial latitude of Earth direction, deg | Earth Mean      | DECE1  90",
"|Celestial longitude of Earth direction, deg| Equinox &       | RAE1   91",
"|X-component of Sun position. km            | Ecliptic of     | XS1    92",
"|Y-component of Sun position, km            | 1950.0          | YS1    93",
"|Z-component of Sun position, km            |        (EC)     | ZS1    94",
"|X-component of Sun velocity, km/sec        |                 | DXS1   95",
"|Y-component of Sun velocity, km/sec        |                 | DYS1   96",
"|Z-component of Sun velocity, km./sec       +                 | DZS1   97",
"|Venus-to-Sun range, km                         +             | RS1    98",
"|Celestial latitude of Sun direction, deg       |             | DESC1  99",
"|Celestial longitude of Sun direction. deg      |             | RAS1  100",
"|Orbit semimajor axis, km                 +     |             | SMA   101",
"|Orbit eccentricity                       |     |             | ECC   102",
"|Time from periapsis, secs                |     |             | TFP   103",
"|Radius of closest approach, km           |     |             | RCA   104",
"|orbit period, day                        |Conic|             | PER   105",
"|Spacecraft true anomaly, deg             |Group|Venus        | TA    106",
"|Orbit inclination, deg                   |     |Centered     | INCL  107",
"|Longitude of ascending node, deg         |     |Earth Mean   | LANL  108",
"|Argument of periapsis, deg               |     |Equinox &    | APF1  109",
"|X-component of unit vector to periapsis  |     |Ecliptic of  | PX1   110",
"|Y-component of unit vector to periapsis  |     |1950.0       | PY1   111",
"|Z-component of unit vector to periapsis  |     |             | PZ1   112",
"|X-component of unit normal to orbit plane|     |             | WX1   113",
"|Y.component of unit normal to orbit plane|     |             | WY1   114",
"|Z-component of unit normal to orbit plane+     |             | WZ1   115",
"|Sun-Venus-probe angle, deg               +Angle|             | S200P 116",
"|Sun-Earth-Venus angle, deg               +Group+             | SE200 117",
"|X-component of probe position, km              +             | XP1   118",
"|Y-component of probe position, km              |             | YP1   119",
"|Z-component of probe position, km              |             | ZP1   120",
"|X-component of probe velocity, km/sec          |             | DXP1  121",
"|Y-conponent of probe  velocity. km/sec         |             | DYP1  122",
"|Z-component of probe velocity, km/sec          |             | DZP1  123",
"|X-conponent of Earth position, km       (EQ)   |Venus        | XE1   124",
"|Y-conponent of Earth position, km       (EQ)   |Centered     | YE1   125",
"|Z-component of Earth position, km       (EQ)   |Earth Mean   | ZE1   126",
"|X-component of Sun position, km         (EQ)   |Equinox &    | XS1   127",
"|Y-component of Sun position, km         (EQ)   |Ecliptic of  | YS1   128",
"|Z-component of Sun position, km         (EQ)   |1950.0       | ZS1   129",
"|X-component of probe position, km              |             | XP2   130",
"|Y-component of probe position, km              |             | YP2   131",
"|Z-component of probe position, km              |             | ZP2   132",
"|X-component of probe velocity, km/sec          |             | DXP2  133",
"|Y-component of probe velocity, km/sec          |             | DYP2  134",
"|Z-component of probe velocity. km/sec+         +             | DZP2  135",
"|Celestial latitude of Earth-to-probe direction,deg (see EN/4)| DECP3 136",
"|Celestial longitude of Earth-to-probe direction,deg          | RAP3  137",
"|                                                             |       138",
"|         Spares                                              |       139",
"|                                                             |       140",
""
};


char *explain[] = {
" ",
"The next several screens will display the columns of the ephemeris file.",
"Many of the columns have explanantory information or grouping information",
"in addition to the column description. These groups are denoted with a",
"vertical bar with plus signs marking the end points, i.e.",
" ",
"                   +",
"                   |",
"                   |",
"                   +",
" ",
"Column numbers are given on the right-hand side of the screen.",
" ",
"The user should enter a comma separated list of the desired columns from each",
"screen (i.e.    10,11, 12,17, 18,19 - note that white space is ignored).",
" ",
"Entering 'none' will continue the selection process without selecting a column.",
"Entering 'quit' will exit the column description/selection process.",
" ",
"Press <return> to continue...",
""
};


int main (int argc, char *argv[]);
void pulse (FILE *ifptr, FILE *ofptr);
int convert_pulse_hdr (PULSE_HDR *pulse_hdr);
void write_pulse_hdr (FILE *ofptr, PULSE_HDR *pulse_hdr);
int convert_pulse_rec (PULSE_DATA *pulse_data);
void write_pulse_rec (FILE *ofptr, PULSE_DATA *pulse_data);
void spin (FILE *ifptr, FILE *ofptr);
int convert_spin_hdr (SPIN_HDR *spin_hdr);
void write_spin_hdr (FILE *ofptr, SPIN_HDR *spin_hdr);
int convert_spin_rec (SPIN_DATA *spin_data);
void write_spin_rec (FILE *ofptr, SPIN_DATA *spin_data);
int ephem (FILE *ifptr, FILE *ofptr, FILE *colptr, int colfile, char name[]);
void mag_ephem (FILE *ifptr, FILE *ofptr);
void sc_to_vso_mat (FILE *ifptr, FILE *ofptr);
int convert_ephem_hdr (EPHEM_HDR *ephem_hdr);
void write_ephem_hdr (FILE *ofptr, EPHEM_HDR *ephem_hdr, int index[], int cnt);
int convert_ephem_rec (EPHEM_ARRAY *ephem_data);
void write_mag_ephem_rec (FILE *ofptr, EPHEM_ARRAY *ephem_data);
void write_vso_mat (FILE *ofptr, EPHEM_ARRAY *ephem_data);
int write_ephem_rec (FILE *ofptr, EPHEM_ARRAY *ephem_data, int index[], int cnt);
void attitude (FILE *ifptr, FILE *ofptr);
int convert_att_hdr (ATT_HDR *att_hdr);
void write_att_hdr (FILE *ofptr, ATT_HDR *att_hdr);
int convert_att_rec (ATT_DATA *att_data);
void write_att_rec (FILE *ofptr, ATT_DATA *att_data);
void sel_roll (FILE *ifptr, FILE *ofptr);
int convert_roll_hdr (ROLL_HDR *roll_hdr);
void write_roll_hdr (FILE *ofptr, ROLL_HDR *roll_hdr);
int convert_roll_rec (ROLL_DATA *roll_data);
void write_roll_rec (FILE *ofptr, ROLL_DATA *roll_data);
void logistic (FILE *ifptr, FILE *ofptr);
void write_sl_hdr (FILE *ofptr, SL_HDR *sl_hdr);
int convert_sl_data (SL_DATA *sl_data);
int write_sl_data (FILE *ofptr, SL_DATA *sl_data);
int PickVarFormat (int host_type);
int usage (int do_exit);
int get_index (int colfile, FILE *colptr, int index[]);
