/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)freelist.c	1.1   (UCLA/IGPP)   11 Dec 1992
 */
/*-- FREELIST -----------------------------------------------------*/
/* Frees the allocated memory acquired by a call to 'copylist'     */
/* and used to hold the list.                                      */
/*                                                                 */
/* Returns:                                                        */
/*  always 0                                                       */
/*                                                                 */
/*  Entry Requirements:                                            */
/*    cnt: The number of entries in the list                       */
/*    list: the list of pointers to free.                          */
/*                                                                 */
/*  Developement History:                                          */
/*    Begun: 03/02/87 - Todd King                                  */
/*                   Under GG44 support                            */
/*-----------------------------------------------------------------*/
#include <malloc.h>

freelist(cnt, list)
int cnt;
char **list;
{
  while(--cnt >= 0) free(list[cnt]);
  return(0);
}
