/*---------------------------------------------------------------*/
/*   Copyright (c) 1993 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- AbbrevTrans ------------------------------------------------
 Translate an abbreviation into its full text equivalent.

 Entry Requirements:
    abbrevList : The list of abbreviations to add the new abbreviation
		 definition to.
    abbrev : The abbreviation text.

 Return Values:
    Pointer to a string containing the translation or the
    passed abbreviation if not translation exists.
                                        
 Development History:                   
   Begun: 03/15/93 - Todd King          
                                        
  Version:                              
     @(#)AbTrans.c	1.2      (UCLA/IGPP)     15 Mar 1993
--------------------------------------------------------------------*/
#include "abbrev.h"	/* For AbbrevNode and NULL */
#include <string.h>	/* For strcmp() */

char *
AbbrevTrans(abbrevList, abbrev)
AbbrevNode	*abbrevList;
char		abbrev[];
{
   AbbrevNode	*node;

   for(node = abbrevList; node != NULL; node = node->next) {
      if(strcmp(abbrev, node->abbrev) == 0) {
	 return(node->trans);
      }
   }
   return(abbrev);
}
