/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*-- TRIMSPC --------------------------------------*/
/* trims leading and trailing spaces from          */
/* a passed string.                                */
/* Considers tabs, space, newline, carriage return */
/* and formfeeds to be white space (per 'isspace') */
/*                                                 */
/*  Begun:  11/21/85 - Todd King                   */
/*               Under GH06 support.               */
/*  Revised: 1/29/87 - Todd King                   */
/*               to also trim tabs, et al:         */
/*               Under GH06 support.               */
/*                                                 */
/*  Version:                                       */
/*     @(#)trimspc.c	1.1      (UCLA/IGPP)     03 Mar 1992                */
/*-------------------------------------------------*/
#include <ctype.h>
#include <string.h>	/* For strlen() */

trimspc(string)
char string[];
{
 int j,n,end;

  j=strlen(string)-1;  /* First xter in string */
  while(isspace(string[j]) && j > 0) j--;  /* trim trailing spaces */
  string[j+1]='\0'; /* truncate */
  j=0;  /* preset */
  while(isspace(string[j]) && string[j] != '\0') j++; /* trim leading spaces */
  if(j>0)  /* shift string left */
  {
    end=strlen(string);
    for(n=0;n<end;n++) string[n]=string[j+n];
  }
  return(0);
}

