/*---------------------------------------------------------------*/
/*   Copyright (c) 1988 Regents of the University of California  */
/*                 All Rights Reserved                           */
/*---------------------------------------------------------------*/
/*
      @(#)buffsetcolval.c	1.3  (UCLA, IGPP) 20 Apr 1994 
 */

/*-- _BUFFSETCOLVAL ------------------*/
/* Sets a column to the given value.  */
/* returns -1 if the value could not  */
/* set for whatever reason.           */
/* Will set a column only if it is    */
/* an output column (if it hasn't     */
/* been removed).  This function is   */
/* named _buffsetcolval because of the*/
/* preprocessor macro definition:     */
/* #define buffsetcolval(a,b)         */
/*       _buffsetcolval(a,(double) b) */
/*                                    */
/* Entry Requirements:                */
/*   RECBUFF:  The buffer which       */
/*             contains the data.     */
/*                                    */
/*   COLNAME: Short name of the       */
/*            column to set.          */
/*                                    */
/*   VALUE:  Value to set column to.  */
/*                                    */
/* Development History of old         */
/*   setcolval function:              */
/*                                    */
/*   Begun:  2/21/86 - Todd King      */
/*         Under GH06 support.        */
/*   Update: 8/6/86  - Marco Zagha    */
/*         Under GG44 support.        */
/*   Update: 9/5/86  - Marco Zagha    */
/*         Under GG44 support.        */
/*                                    */
/* Development History of the         */
/*   _buffsetcolval function:         */
/*                                    */
/*   Begun: 5/7/87 - Marco Zagha      */
/*         Under GG44 support.        */
/*   Edited:04/14/94 - Gilbert Hyatt  */
/*     Now uses pipec.h as entry point*/
/*     into the library.              */
/*------------------------------------*/
_buffsetcolval(recbuff, colname, value)
char	recbuff[];
char	colname[];
double	value;
{
#include "pipec.h"

  union overlay
  { int ival;
    float fval;
    double dval;
    char text[sizeof(double)];
  } overlay;

  int descno;
  int begin,last,i;

  extern DESC Desc[];


  descno = excolnum(colname);
  descno--;
  if (descno < 0) return(-1);    		/* Not valid column name */

  switch(Desc[descno].type)
  {
    case 'I':
  	      overlay.ival = (int) value;
	      last=sizeof(int);
	      begin=Desc[descno].start;
	      for(i=0;i<last;i++) recbuff[begin+i]=overlay.text[i];
	      break;
    case 'R':
  	      overlay.fval = (float) value;
	      last=sizeof(float);
	      begin=Desc[descno].start;
	      for(i=0;i<last;i++) recbuff[begin+i]=overlay.text[i];
	      break;
    case 'T':
    case 'D':
  	      overlay.dval = value;
	      last=sizeof(double);
	      begin=Desc[descno].start;
	      for(i=0;i<last;i++) recbuff[begin+i]=overlay.text[i];
	      break;
    default:
	      return (-1); /* Setcolstr(colname, string) is for strings */
  }
  return(0);
}
